/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneBoundMarker
extends AbstractRangeTombstoneMarker<ClusteringBound> {
    private final DeletionTime deletion;

    public RangeTombstoneBoundMarker(ClusteringBound bound, DeletionTime deletion) {
        super(bound);
        this.deletion = deletion;
    }

    public static RangeTombstoneBoundMarker inclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        ClusteringBound bound = ClusteringBound.inclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker exclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        ClusteringBound bound = ClusteringBound.exclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker inclusiveClose(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        ClusteringBound bound = ClusteringBound.inclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker exclusiveClose(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        ClusteringBound bound = ClusteringBound.exclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    @Override
    public boolean isBoundary() {
        return false;
    }

    public DeletionTime deletionTime() {
        return this.deletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return ((ClusteringBound)this.bound).isInclusive();
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return ((ClusteringBound)this.bound).isInclusive();
    }

    @Override
    public ClusteringBound openBound(boolean reversed) {
        return this.isOpen(reversed) ? (ClusteringBound)this.clustering() : null;
    }

    @Override
    public ClusteringBound closeBound(boolean reversed) {
        return this.isClose(reversed) ? (ClusteringBound)this.clustering() : null;
    }

    @Override
    public RangeTombstoneBoundMarker copy(AbstractAllocator allocator) {
        return new RangeTombstoneBoundMarker(((ClusteringBound)this.clustering()).copy(allocator), this.deletion);
    }

    @Override
    public RangeTombstoneBoundMarker withNewOpeningDeletionTime(boolean reversed, DeletionTime newDeletionTime) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return new RangeTombstoneBoundMarker((ClusteringBound)this.clustering(), newDeletionTime);
    }

    @Override
    public void digest(MessageDigest digest) {
        ((ClusteringBound)this.bound).digest(digest);
        this.deletion.digest(digest);
    }

    @Override
    public String toString(CFMetaData metadata) {
        return "Marker " + ((ClusteringBound)this.bound).toString(metadata) + '@' + this.deletion.markedForDeleteAt();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundMarker)) {
            return false;
        }
        RangeTombstoneBoundMarker that = (RangeTombstoneBoundMarker)other;
        return ((ClusteringBound)this.bound).equals(that.bound) && this.deletion.equals(that.deletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.deletion);
    }
}

