/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.MessageObserver;

public class ClientRequestFilterInterceptor
extends AbstractOutDatabindingInterceptor {
    public ClientRequestFilterInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message outMessage) throws Fault {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(outMessage);
        if (pf == null) {
            return;
        }
        List<ProviderInfo<ClientRequestFilter>> filters = pf.getClientRequestFilters();
        if (!filters.isEmpty()) {
            Exchange exchange = outMessage.getExchange();
            ClientRequestContextImpl context = new ClientRequestContextImpl(outMessage, false);
            for (ProviderInfo<ClientRequestFilter> filter : filters) {
                InjectionUtils.injectContexts((Object)filter.getProvider(), filter, (Message)outMessage);
                try {
                    ((ClientRequestFilter)filter.getProvider()).filter((ClientRequestContext)context);
                    Map headers = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)));
                    HttpUtils.convertHeaderValuesToString((Map)headers, (boolean)false);
                    Response response = (Response)outMessage.getExchange().get(Response.class);
                    if (response == null) continue;
                    outMessage.getInterceptorChain().abort();
                    MessageImpl inMessage = new MessageImpl();
                    inMessage.setExchange(exchange);
                    inMessage.put((Object)Message.RESPONSE_CODE, (Object)response.getStatus());
                    inMessage.put((Object)Message.PROTOCOL_HEADERS, (Object)response.getMetadata());
                    exchange.setInMessage((Message)inMessage);
                    MessageObserver observer = (MessageObserver)exchange.get(MessageObserver.class);
                    observer.onMessage((Message)inMessage);
                    return;
                }
                catch (IOException ex) {
                    throw new ProcessingException((Throwable)ex);
                }
            }
        }
    }
}

