/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit5;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.junit5.MeecrowaveConfig;
import org.apache.meecrowave.testing.Injector;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class MeecrowaveExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MeecrowaveExtension.class.getName()});

    public void beforeAll(ExtensionContext context) throws Exception {
        String ctx;
        Meecrowave.Builder builder = new Meecrowave.Builder();
        Optional<MeecrowaveConfig> meecrowaveConfig = context.getElement().map(e -> e.getAnnotation(MeecrowaveConfig.class));
        if (meecrowaveConfig.isPresent()) {
            MeecrowaveConfig config = meecrowaveConfig.get();
            ctx = config.context();
            for (Method method : MeecrowaveConfig.class.getMethods()) {
                if (MeecrowaveConfig.class != method.getDeclaringClass()) continue;
                try {
                    Object value = method.invoke((Object)config, new Object[0]);
                    Field configField = Meecrowave.Builder.class.getDeclaredField(method.getName());
                    if (!configField.isAccessible()) {
                        configField.setAccessible(true);
                    }
                    if (value == null || String.class.isInstance(value) && value.toString().isEmpty()) continue;
                    if (!configField.isAccessible()) {
                        configField.setAccessible(true);
                    }
                    configField.set(builder, File.class == configField.getType() ? new File(value.toString()) : value);
                }
                catch (NoSuchFieldException value) {
                }
                catch (Exception e2) {
                    throw new IllegalStateException(e2);
                }
            }
            if (builder.getHttpPort() < 0) {
                builder.randomHttpPort();
            }
        } else {
            ctx = "";
        }
        Meecrowave meecrowave = new Meecrowave(builder);
        context.getStore(NAMESPACE).put((Object)Meecrowave.class.getName(), (Object)meecrowave);
        context.getStore(NAMESPACE).put((Object)Meecrowave.Builder.class.getName(), (Object)builder);
        meecrowave.bake(ctx);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ((Meecrowave)Meecrowave.class.cast(context.getStore(NAMESPACE).get((Object)Meecrowave.class.getName()))).close();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.getScopes(context).ifPresent(scopes -> {
            ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
            Stream.of(scopes).forEach(s -> contextsService.startContext(s, null));
        });
        context.getStore(NAMESPACE).put((Object)CreationalContext.class.getName(), Injector.inject(context.getTestInstance().orElse(null)));
        Injector.injectConfig((Meecrowave.Builder)Meecrowave.Builder.class.cast(context.getStore(NAMESPACE).get((Object)Meecrowave.Builder.class.getName())), context.getTestInstance().orElse(null));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ((CreationalContext)CreationalContext.class.cast(context.getStore(NAMESPACE).get((Object)CreationalContext.class.getName()))).release();
        this.getScopes(context).ifPresent(scopes -> {
            ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(scopes));
            Collections.reverse(list);
            list.forEach(s -> contextsService.endContext(s, null));
        });
    }

    private Optional<Class<? extends Annotation>[]> getScopes(ExtensionContext context) {
        return context.getElement().map(e -> e.getAnnotation(MeecrowaveConfig.class)).map(MeecrowaveConfig::scopes).filter(s -> ((Class[])s).length > 0);
    }
}

