/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.generic.Type;

public abstract class FieldGenOrMethodGen
extends Modifiers {
    protected String name;
    protected Type type;
    protected ConstantPool cp;
    private ArrayList<Attribute> attributeList = new ArrayList();
    protected ArrayList<AnnotationGen> annotationList = new ArrayList();

    protected FieldGenOrMethodGen() {
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.cp = constantPool;
    }

    public void addAttribute(Attribute attribute) {
        this.attributeList.add(attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributeList.remove(attribute);
    }

    public void removeAttributes() {
        this.attributeList.clear();
    }

    public List<AnnotationGen> getAnnotations() {
        return this.annotationList;
    }

    public void addAnnotation(AnnotationGen annotationGen) {
        this.annotationList.add(annotationGen);
    }

    public void removeAnnotation(AnnotationGen annotationGen) {
        this.annotationList.remove(annotationGen);
    }

    public void removeAnnotations() {
        this.annotationList.clear();
    }

    public List<Attribute> getAttributes() {
        return this.attributeList;
    }

    public Attribute[] getAttributesImmutable() {
        Attribute[] attributeArray = new Attribute[this.attributeList.size()];
        this.attributeList.toArray(attributeArray);
        return attributeArray;
    }

    protected void addAnnotationsAsAttribute(ConstantPool constantPool) {
        Collection<RuntimeAnnos> collection = Utility.getAnnotationAttributes(constantPool, this.annotationList);
        if (collection != null) {
            for (Attribute attribute : collection) {
                this.addAttribute(attribute);
            }
        }
    }

    public abstract String getSignature();
}

