/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableShortObjectMapFactory;
import org.eclipse.collections.api.map.primitive.MutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ShortObjectMap;
import org.eclipse.collections.impl.factory.primitive.ShortObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ShortObjectHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableShortObjectMapFactoryImpl implements MutableShortObjectMapFactory
{
    INSTANCE;


    public <V> MutableShortObjectMap<V> empty() {
        return new ShortObjectHashMap(0);
    }

    public <V> MutableShortObjectMap<V> of() {
        return this.empty();
    }

    public <V> MutableShortObjectMap<V> with() {
        return this.empty();
    }

    public <V> MutableShortObjectMap<V> ofAll(ShortObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> MutableShortObjectMap<V> withAll(ShortObjectMap<? extends V> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ShortObjectHashMap<V>(map);
    }

    public <T, V> MutableShortObjectMap<V> from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableShortObjectMap map = ShortObjectMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.shortValueOf(each), valueFunction.valueOf(each)));
        return map;
    }
}

