/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedIntStack;

public class UnmodifiableIntStack
implements MutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntStack stack;

    public UnmodifiableIntStack(MutableIntStack stack) {
        this.stack = stack;
    }

    public void push(int item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public int pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public IntList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public int peek() {
        return this.stack.peek();
    }

    public IntList peek(int count) {
        return this.stack.peek(count);
    }

    public int peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(int value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.stack.containsAll(source);
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.stack.intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableIntStack select(IntPredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableIntStack reject(IntPredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public int max() {
        return this.stack.max();
    }

    public int min() {
        return this.stack.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public int maxIfEmpty(int defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableIntList toSortedList() {
        return this.stack.toSortedList();
    }

    public int[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public int[] toArray() {
        return this.stack.toArray();
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableIntList toList() {
        return this.stack.toList();
    }

    public MutableIntSet toSet() {
        return this.stack.toSet();
    }

    public MutableIntBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public MutableIntStack asUnmodifiable() {
        return this;
    }

    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAllReversed((IntIterable)this);
    }

    public MutableIntStack newEmpty() {
        return this.stack.newEmpty();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectInto(injectedValue, function);
    }

    public RichIterable<IntIterable> chunk(int size) {
        return this.stack.chunk(size);
    }

    public int getFirst() {
        return this.stack.getFirst();
    }

    public int indexOf(int value) {
        return this.stack.indexOf(value);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectIntoWithIndex(injectedValue, function);
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        this.stack.forEachWithIndex(procedure);
    }

    public <V> MutableStack<V> collectWithIndex(IntIntToObjectFunction<? extends V> function) {
        return this.stack.collectWithIndex(function);
    }

    public <V, R extends Collection<V>> R collectWithIndex(IntIntToObjectFunction<? extends V> function, R target) {
        return (R)this.stack.collectWithIndex(function, target);
    }
}

