/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.util;

import java.io.InputStream;
import java.net.URL;

public class Loader {
    public static Class loadClass(String className) throws ClassNotFoundException {
        return Loader.loadClass(className, Loader.class);
    }

    public static Class loadClass(String className, Class currentClass) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Loader.getClassLoader(currentClass);
        Class<?> aClass = contextClassLoader.loadClass(className);
        return aClass;
    }

    public static URL getResource(String resourceName) {
        return Loader.getResource(resourceName, Loader.class);
    }

    public static URL getResource(String resourceName, Class currentClass) {
        return Loader.getClassLoader(currentClass).getResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        return Loader.getResourceAsStream(resourceName, Loader.class);
    }

    public static InputStream getResourceAsStream(String resourceName, Class currentClass) {
        InputStream is = Loader.getClassLoader(currentClass).getResourceAsStream(resourceName);
        if (is == null) {
            is = currentClass.getResourceAsStream(resourceName);
        }
        return is;
    }

    public static ClassLoader getClassLoader(Class currentClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            contextClassLoader = currentClass.getClassLoader();
        }
        return contextClassLoader;
    }
}

