/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import java.util.Objects;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.column.Column;

final class DefaultColumn
implements Column {
    private final String name;
    private final Value value;

    DefaultColumn(String name, Value value) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.value.get(clazz);
    }

    @Override
    public <T> T get(TypeSupplier<T> typeSupplier) {
        return (T)this.value.get(typeSupplier);
    }

    @Override
    public Object get() {
        return this.value.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.value, that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultColumn{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

