/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.query.BaseQueryBuilder;
import org.jnosql.diana.api.column.query.ColumnFrom;
import org.jnosql.diana.api.column.query.ColumnLimit;
import org.jnosql.diana.api.column.query.ColumnNameCondition;
import org.jnosql.diana.api.column.query.ColumnNameOrder;
import org.jnosql.diana.api.column.query.ColumnNotCondition;
import org.jnosql.diana.api.column.query.ColumnOrder;
import org.jnosql.diana.api.column.query.ColumnSelect;
import org.jnosql.diana.api.column.query.ColumnStart;
import org.jnosql.diana.api.column.query.ColumnWhere;
import org.jnosql.diana.api.column.query.DefaultColumnQuery;

class DefaultSelectQueryBuilder
extends BaseQueryBuilder
implements ColumnSelect,
ColumnFrom,
ColumnLimit,
ColumnStart,
ColumnOrder,
ColumnNameCondition,
ColumnNotCondition,
ColumnNameOrder,
ColumnWhere {
    private String columnFamily;
    private long start;
    private long limit;
    private final List<Sort> sorts = new ArrayList<Sort>();
    private final List<String> columns;

    DefaultSelectQueryBuilder(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public ColumnFrom from(String columnFamily) {
        Objects.requireNonNull(columnFamily, "columnFamily is required");
        this.columnFamily = columnFamily;
        return this;
    }

    @Override
    public ColumnNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public ColumnNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    @Override
    public ColumnNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    @Override
    public ColumnStart start(long start) {
        this.start = start;
        return this;
    }

    @Override
    public ColumnLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public ColumnOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    @Override
    public ColumnNotCondition not() {
        this.negate = true;
        return this;
    }

    @Override
    public <T> ColumnWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    @Override
    public ColumnWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    @Override
    public ColumnWhere gt(Number value) {
        this.gtImpl(value);
        return this;
    }

    @Override
    public ColumnWhere gte(Number value) {
        this.gteImpl(value);
        return this;
    }

    @Override
    public ColumnWhere lt(Number value) {
        this.ltImpl(value);
        return this;
    }

    @Override
    public ColumnWhere lte(Number value) {
        this.lteImpl(value);
        return this;
    }

    @Override
    public ColumnWhere between(Number valueA, Number valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    @Override
    public <T> ColumnWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    @Override
    public ColumnNameOrder asc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.ASC));
        return this;
    }

    @Override
    public ColumnNameOrder desc() {
        this.sorts.add(Sort.of((String)this.name, (Sort.SortType)Sort.SortType.DESC));
        return this;
    }

    @Override
    public ColumnQuery build() {
        return new DefaultColumnQuery(this.limit, this.start, this.columnFamily, this.columns, this.sorts, this.condition);
    }
}

