/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Objects;
import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnCondition;

class ReadOnlyColumnCondition
implements ColumnCondition {
    private final ColumnCondition condition;

    ReadOnlyColumnCondition(ColumnCondition condition) {
        this.condition = Objects.requireNonNull(condition, "condition is required");
    }

    @Override
    public Column getColumn() {
        return this.condition.getColumn();
    }

    @Override
    public Condition getCondition() {
        return this.condition.getCondition();
    }

    @Override
    public ColumnCondition and(ColumnCondition condition) {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    @Override
    public ColumnCondition negate() {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    @Override
    public ColumnCondition or(ColumnCondition condition) {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !ColumnCondition.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        ColumnCondition that = (ColumnCondition)o;
        return Objects.equals(this.condition, that);
    }

    public int hashCode() {
        return Objects.hashCode(this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyColumnCondition{");
        sb.append("condition=").append(this.condition);
        sb.append('}');
        return sb.toString();
    }
}

