/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.util.Objects;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;

final class DefaultDocument
implements Document {
    private final String name;
    private final Value value;

    DefaultDocument(String name, Value value) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.value.get(clazz);
    }

    @Override
    public <T> T get(TypeSupplier<T> typeSupplier) {
        return (T)this.value.get(typeSupplier);
    }

    @Override
    public Object get() {
        return this.value.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDocument)) {
            return false;
        }
        Document that = (Document)o;
        return Objects.equals(this.name, that.getName()) && Objects.equals(this.value, that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Document{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

