/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.ReadOnlyDocumentCondition;

class DefaultDocumentQuery
implements DocumentQuery {
    private final long maxResult;
    private final long firstResult;
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<Sort> sorts;
    private final List<String> documents;

    DefaultDocumentQuery(long maxResult, long firstResult, String documentCollection, List<String> documents, List<Sort> sorts, DocumentCondition condition) {
        this.maxResult = maxResult;
        this.firstResult = firstResult;
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(ReadOnlyDocumentCondition::new).orElse(null);
        this.sorts = sorts;
        this.documents = documents;
    }

    @Override
    public long getMaxResults() {
        return this.maxResult;
    }

    @Override
    public long getFirstResult() {
        return this.firstResult;
    }

    @Override
    public String getDocumentCollection() {
        return this.documentCollection;
    }

    @Override
    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<Sort> getSorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    @Override
    public List<String> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.maxResult == that.getMaxResults() && this.firstResult == that.getFirstResult() && Objects.equals(this.documentCollection, that.getDocumentCollection()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.documents, that.getDocuments());
    }

    public int hashCode() {
        return Objects.hash(this.maxResult, this.firstResult, this.documentCollection, this.condition, this.sorts, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDocumentQuery{");
        sb.append("maxResult=").append(this.maxResult);
        sb.append(", firstResult=").append(this.firstResult);
        sb.append(", documentCollection='").append(this.documentCollection).append('\'');
        sb.append(", condition=").append(this.condition);
        sb.append(", sorts=").append(this.sorts);
        sb.append(", documents=").append(this.documents);
        sb.append('}');
        return sb.toString();
    }
}

