/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Objects;
import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

class ReadOnlyDocumentCondition
implements DocumentCondition {
    private final DocumentCondition condition;

    ReadOnlyDocumentCondition(DocumentCondition condition) {
        this.condition = Objects.requireNonNull(condition, "condition is required");
    }

    @Override
    public Document getDocument() {
        return this.condition.getDocument();
    }

    @Override
    public Condition getCondition() {
        return this.condition.getCondition();
    }

    @Override
    public DocumentCondition and(DocumentCondition condition) {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    @Override
    public DocumentCondition negate() {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    @Override
    public DocumentCondition or(DocumentCondition condition) {
        throw new IllegalStateException("You cannot change the status after building the query");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !DocumentCondition.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DocumentCondition that = (DocumentCondition)o;
        return Objects.equals(this.condition, that);
    }

    public int hashCode() {
        return Objects.hashCode(this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyDocumentCondition{");
        sb.append("condition=").append(this.condition);
        sb.append('}');
        return sb.toString();
    }
}

