/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.hazelcast.key;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Settings;
import org.jnosql.diana.api.key.KeyValueConfiguration;
import org.jnosql.diana.driver.ConfigurationReader;
import org.jnosql.diana.hazelcast.key.DefaultHazelcastBucketManagerFactory;
import org.jnosql.diana.hazelcast.key.HazelcastBucketManagerFactory;

public class HazelcastKeyValueConfiguration
implements KeyValueConfiguration<HazelcastBucketManagerFactory> {
    private static final String HAZELCAST_FILE_CONFIGURATION = "diana-hazelcast.properties";

    public HazelcastBucketManagerFactory get(Map<String, String> configurations) throws NullPointerException {
        List servers = configurations.keySet().stream().filter(s -> s.startsWith("hazelcast-hoster-")).collect(Collectors.toList());
        Config config = new Config(configurations.getOrDefault("hazelcast-instanceName", "hazelcast-instanceName"));
        HazelcastInstance hazelcastInstance = Hazelcast.getOrCreateHazelcastInstance((Config)config);
        return new DefaultHazelcastBucketManagerFactory(hazelcastInstance);
    }

    public HazelcastBucketManagerFactory get(Config config) throws NullPointerException {
        Objects.requireNonNull(config, "config is required");
        HazelcastInstance hazelcastInstance = Hazelcast.getOrCreateHazelcastInstance((Config)config);
        return new DefaultHazelcastBucketManagerFactory(hazelcastInstance);
    }

    public HazelcastBucketManagerFactory get() {
        Map configuration = ConfigurationReader.from((String)HAZELCAST_FILE_CONFIGURATION);
        return this.get(configuration);
    }

    public HazelcastBucketManagerFactory get(Settings settings) {
        Objects.requireNonNull(settings, "settings is required");
        HashMap<String, String> configurations = new HashMap<String, String>();
        settings.forEach((key, value) -> configurations.put((String)key, value.toString()));
        return this.get(configurations);
    }
}

