/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldTypeMatcherStrategy;
import org.powermock.reflect.internal.primitivesupport.PrimitiveWrapper;

public class AssignableFromFieldTypeMatcherStrategy
extends FieldTypeMatcherStrategy {
    private final Class<?> primitiveCounterpart;

    public AssignableFromFieldTypeMatcherStrategy(Class<?> fieldType) {
        super(fieldType);
        this.primitiveCounterpart = PrimitiveWrapper.getPrimitiveFromWrapperType(this.expectedFieldType);
    }

    @Override
    public boolean matches(Field field) {
        Class<?> actualFieldType = field.getType();
        return actualFieldType.isAssignableFrom(this.expectedFieldType) || this.primitiveCounterpart != null && actualFieldType.isAssignableFrom(this.primitiveCounterpart);
    }

    @Override
    public void notFound(Class<?> type, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field assignable from \"%s\" could be found in the class hierarchy of %s.", isInstanceField ? "instance" : "static", this.expectedFieldType.getName(), type.getName()));
    }

    @Override
    public String toString() {
        return "type " + (this.primitiveCounterpart == null ? this.expectedFieldType.getName() : this.primitiveCounterpart.getName());
    }
}

