/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.factory;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import reactor.function.Supplier;
import reactor.util.Assert;

public class CreateOrReuseFactoryBean<T>
implements FactoryBean<T>,
BeanFactoryAware,
InitializingBean {
    private final Object monitor = new Object(){};
    private final String self;
    private final Class<T> type;
    private final Supplier<T> supplier;
    private ListableBeanFactory beanFactory;
    private T instance;

    public CreateOrReuseFactoryBean(String self, Class<T> type, Supplier<T> supplier) {
        Assert.notNull((Object)self, (String)"'self' Bean name cannot be null.");
        Assert.notNull(type, (String)"Bean type cannot be null.");
        Assert.notNull(supplier, (String)"Supplier cannot be null.");
        this.self = self;
        this.type = type;
        this.supplier = supplier;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"ListableBeanFactory cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (null == this.instance) {
                String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, this.type);
                this.instance = names.length == 0 || names[0].equals(this.self) ? this.supplier.get() : this.beanFactory.getBean(names[0]);
            }
            return this.instance;
        }
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }
}

