/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.r2dbc.config.AbstractR2dbcConfiguration;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;

@Configuration
@ConditionalOnClass(value={DatabaseClient.class})
@ConditionalOnMissingBean(value={DatabaseClient.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@AutoConfigureAfter(value={ConnectionFactoryAutoConfiguration.class})
public class R2dbcDataAutoConfiguration
extends AbstractR2dbcConfiguration {
    private final ConnectionFactory connectionFactory;

    public R2dbcDataAutoConfiguration(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    @Bean
    public DatabaseClient databaseClient(ReactiveDataAccessStrategy dataAccessStrategy, R2dbcExceptionTranslator exceptionTranslator) {
        return DatabaseClient.builder().connectionFactory(this.connectionFactory()).dataAccessStrategy(dataAccessStrategy).exceptionTranslator(exceptionTranslator).build();
    }
}

