/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.r2dbc.connectionfactory.R2dbcTransactionManager;
import org.springframework.transaction.ReactiveTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={R2dbcTransactionManager.class, ReactiveTransactionManager.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
public class R2dbcTransactionManagerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
    static class ConnectionFactoryTransactionManagerConfiguration {
        ConnectionFactoryTransactionManagerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveTransactionManager.class})
        public R2dbcTransactionManager connectionFactoryTransactionManager(ConnectionFactory connectionFactory) {
            return new R2dbcTransactionManager(connectionFactory);
        }
    }
}

