/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={ConnectionFactory.class, EmbeddedDatabaseType.class})
@EnableConfigurationProperties(value={R2dbcProperties.class})
public class ConnectionFactoryAutoConfiguration {

    static class PooledConnectionUrlCondition
    extends SpringBootCondition {
        PooledConnectionUrlCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String url = context.getEnvironment().getProperty("spring.r2dbc.url");
            if (StringUtils.isEmpty((Object)url)) {
                return ConditionOutcome.match((String)"R2DBC Connection URL is empty");
            }
            if (url.contains(":pool:")) {
                return ConditionOutcome.match((String)"R2DBC Connection URL contains pooling configuration");
            }
            return ConditionOutcome.noMatch((String)"R2DBC Connection URL does not contain pooling configuration");
        }
    }

    static class UnpooledConnectionUrlCondition
    extends SpringBootCondition {
        UnpooledConnectionUrlCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String url = context.getEnvironment().getProperty("spring.r2dbc.url");
            if (StringUtils.isEmpty((Object)url)) {
                return ConditionOutcome.match((String)"R2DBC Connection URL is empty");
            }
            if (url.contains(":pool:")) {
                return ConditionOutcome.noMatch((String)"R2DBC Connection URL contains pooling configuration");
            }
            return ConditionOutcome.match((String)"R2DBC Connection URL does not contain pooling configuration");
        }
    }

    static class EmbeddedDatabaseCondition
    extends SpringBootCondition {
        EmbeddedOptOutCondition pooledCondition = new EmbeddedOptOutCondition();

        EmbeddedDatabaseCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"EmbeddedDataSource", (Object[])new Object[0]);
            if (this.anyMatches(context, metadata, new Condition[]{this.pooledCondition})) {
                return ConditionOutcome.noMatch((ConditionMessage)message.foundExactly((Object)"supported pooled data source"));
            }
            EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(context.getClassLoader()).getType();
            if (type == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("embedded database").atAll());
            }
            return ConditionOutcome.match((ConditionMessage)message.found("embedded database").items(new Object[]{type}));
        }
    }

    static class GenericDataSourceCondition
    extends AnyNestedCondition {
        GenericDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={PooledConnectionUrlCondition.class})
        static class PooledConnectionUrl {
            PooledConnectionUrl() {
            }
        }

        @ConditionalOnMissingClass(value={"io.r2dbc.pool.ConnectionPool"})
        static class NoConnectionPool {
            NoConnectionPool() {
            }
        }
    }

    static class EmbeddedOptOutCondition
    extends AnyNestedCondition {
        EmbeddedOptOutCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"spring.r2dbc.url"})
        static class ExplicitUrl {
            ExplicitUrl() {
            }
        }
    }

    @Configuration
    @Conditional(value={GenericDataSourceCondition.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @Import(value={ConnectionFactoryConfiguration.Generic.class})
    @ConditionalOnProperty(value={"spring.r2dbc.url"})
    protected static class GenericConnectionFactoryConfiguration {
        protected GenericConnectionFactoryConfiguration() {
        }
    }

    @Configuration
    @Conditional(value={UnpooledConnectionUrlCondition.class})
    @ConditionalOnClass(value={ConnectionPool.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @Import(value={ConnectionFactoryConfiguration.ConnectionPoolConnectionFactoryConfiguration.class})
    @ConditionalOnProperty(value={"spring.r2dbc.url"})
    protected static class PooledConnectionFactoryConfiguration {
        protected PooledConnectionFactoryConfiguration() {
        }
    }

    @Configuration
    @Conditional(value={EmbeddedDatabaseCondition.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @Import(value={EmbeddedDatabaseConfiguration.class})
    protected static class EmbeddedConfiguration {
        protected EmbeddedConfiguration() {
        }
    }
}

