/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class ConnectionFactoryBuilder {
    private static final String[] CONNECTION_FACTORY_TYPE_NAMES = new String[]{"io.r2dbc.pool.ConnectionPool"};
    private final ConnectionFactoryOptions.Builder builder;

    public static ConnectionFactoryBuilder create(R2dbcProperties properties) {
        String databaseName;
        String password;
        ConnectionFactoryOptions.Builder builder = ConnectionFactoryOptions.parse((CharSequence)properties.determineUrl()).mutate();
        String username = properties.determineUsername();
        if (StringUtils.hasText((String)username)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)username);
        }
        if (StringUtils.hasText((String)(password = properties.determinePassword()))) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)password);
        }
        if (StringUtils.hasText((String)(databaseName = properties.determineDatabaseName()))) {
            builder.option(ConnectionFactoryOptions.DATABASE, (Object)databaseName);
        }
        if (properties.getProperties() != null) {
            properties.getProperties().forEach((key, value) -> builder.option(Option.valueOf((String)key), value));
        }
        return new ConnectionFactoryBuilder(builder);
    }

    public static ConnectionFactoryBuilder create() {
        return new ConnectionFactoryBuilder(ConnectionFactoryOptions.builder());
    }

    private ConnectionFactoryBuilder(ConnectionFactoryOptions.Builder builder) {
        this.builder = builder;
    }

    public ConnectionFactoryBuilder username(String username) {
        this.builder.option(ConnectionFactoryOptions.USER, (Object)username);
        return this;
    }

    public ConnectionFactoryBuilder password(String password) {
        this.builder.option(ConnectionFactoryOptions.PASSWORD, (Object)password);
        return this;
    }

    public ConnectionFactoryBuilder hostname(String host) {
        this.builder.option(ConnectionFactoryOptions.HOST, (Object)host);
        return this;
    }

    public ConnectionFactoryBuilder port(int port) {
        this.builder.option(ConnectionFactoryOptions.PORT, (Object)port);
        return this;
    }

    public ConnectionFactoryBuilder database(String database) {
        this.builder.option(ConnectionFactoryOptions.DATABASE, (Object)database);
        return this;
    }

    public ConnectionFactory build() {
        return ConnectionFactories.get((ConnectionFactoryOptions)this.builder.build());
    }

    public static Class<? extends DataSource> findType(ClassLoader classLoader) {
        for (String name : CONNECTION_FACTORY_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

