/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

public class ConnectionFactoryConfiguration {

    @Configuration
    protected static class Generic {
        protected Generic() {
        }

        @Bean
        ConnectionFactory connectionFactory(R2dbcProperties properties) {
            return ConnectionFactoryBuilder.create(properties).build();
        }
    }

    @Configuration
    protected static class ConnectionPoolConnectionFactoryConfiguration {
        protected ConnectionPoolConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="dispose")
        ConnectionPool connectionFactory(R2dbcProperties properties) {
            ConnectionFactory connectionFactory = ConnectionFactoryBuilder.create(properties).build();
            R2dbcProperties.Pool pool = properties.getPool();
            ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).maxSize(pool.getMaxSize()).initialSize(pool.getInitialSize()).maxIdleTime(pool.getMaxIdleTime());
            if (StringUtils.hasText((String)pool.getValidationQuery())) {
                builder.validationQuery(pool.getValidationQuery());
            }
            return new ConnectionPool(builder.build());
        }
    }
}

