/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.sql.Connection;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDataSourceConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Connection.class, ConnectionFactory.class})
@EnableConfigurationProperties(value={R2dbcProperties.class})
@AutoConfigureAfter(value={EmbeddedDataSourceConfiguration.class})
public class EmbeddedDatabaseConfiguration
implements BeanClassLoaderAware {
    private EmbeddedDatabase database;
    private ClassLoader classLoader;
    private final R2dbcProperties properties;

    public EmbeddedDatabaseConfiguration(R2dbcProperties properties) {
        this.properties = properties;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Bean
    @ConditionalOnMissingBean(value={EmbeddedDatabase.class, EmbeddedDatabaseConnectionInformation.class})
    public EmbeddedDatabaseConnectionInformation embeddedDatabaseNameFromR2dbc() {
        return new EmbeddedDatabaseConnectionInformation(this.properties.determineDatabaseName(), this.properties.determineUsername(), this.properties.determinePassword());
    }

    @Bean
    @ConditionalOnMissingBean(value={EmbeddedDatabaseConnectionInformation.class})
    @ConditionalOnBean(value={EmbeddedDatabase.class, DataSourceProperties.class})
    public EmbeddedDatabaseConnectionInformation embeddedDatabaseNameFromJdbc(DataSourceProperties jdbcProperties) {
        return new EmbeddedDatabaseConnectionInformation(jdbcProperties.determineDatabaseName(), jdbcProperties.determineUsername(), jdbcProperties.determinePassword());
    }

    @Bean
    @ConditionalOnMissingBean
    public EmbeddedDatabase dataSource(EmbeddedDatabaseConnectionInformation embedded) {
        this.database = new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseConnection.get(this.classLoader).getType()).setName(this.properties.determineDatabaseName()).build();
        return this.database;
    }

    @Bean
    public ConnectionFactory connectionFactory(EmbeddedDatabaseConnectionInformation embedded) {
        EmbeddedDatabaseConnection connection = EmbeddedDatabaseConnection.get(this.classLoader);
        ConnectionFactoryOptions.Builder builder = ConnectionFactoryOptions.parse((CharSequence)connection.getUrl(embedded.getName())).mutate();
        if (StringUtils.hasText((String)embedded.getUsername())) {
            builder.option(ConnectionFactoryOptions.USER, (Object)embedded.getUsername());
        }
        if (StringUtils.hasText((String)embedded.getUsername())) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)embedded.getPassword());
        }
        return ConnectionFactories.get((ConnectionFactoryOptions)builder.build());
    }

    @PreDestroy
    public void close() {
        if (this.database != null) {
            this.database.shutdown();
        }
    }

    static class EmbeddedDatabaseConnectionInformation {
        final String name;
        final String username;
        final String password;

        EmbeddedDatabaseConnectionInformation(String name, String username, String password) {
            this.name = name;
            this.username = username;
            this.password = password;
        }

        String getName() {
            return this.name;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

