/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum EmbeddedDatabaseConnection {
    NONE(null, null, null, null),
    H2(EmbeddedDatabaseType.H2, "io.r2dbc.h2.H2ConnectionFactoryProvider", "h2", "r2dbc:h2:mem://in-memory/%s?options=DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE");

    private final EmbeddedDatabaseType type;
    private final String driverClassName;
    private final String driver;
    private final String url;

    private EmbeddedDatabaseConnection(EmbeddedDatabaseType type, String driverClassName, String driver, String url) {
        this.type = type;
        this.driverClassName = driverClassName;
        this.driver = driver;
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriver() {
        return this.driver;
    }

    public EmbeddedDatabaseType getType() {
        return this.type;
    }

    public String getUrl(String databaseName) {
        Assert.hasText((String)databaseName, (String)"DatabaseName must not be empty");
        return this.url != null ? String.format(this.url, databaseName) : null;
    }

    public static EmbeddedDatabaseConnection get(ClassLoader classLoader) {
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE || !ClassUtils.isPresent((String)candidate.getDriverClassName(), (ClassLoader)classLoader)) continue;
            return candidate;
        }
        return NONE;
    }

    public static boolean isEmbedded(String driver) {
        return driver != null && driver.equals(EmbeddedDatabaseConnection.H2.driver);
    }
}

