/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.client.R2dbc;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={R2dbc.class})
@ConditionalOnMissingBean(value={R2dbc.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@AutoConfigureAfter(value={ConnectionFactoryAutoConfiguration.class})
public class R2dbcAutoConfiguration {
    private final ConnectionFactory connectionFactory;

    public R2dbcAutoConfiguration(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Bean
    public R2dbc r2dbc() {
        return new R2dbc(this.connectionFactory);
    }
}

