/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.r2dbc")
public class R2dbcProperties
implements BeanClassLoaderAware,
InitializingBean {
    private ClassLoader classLoader;
    private String name;
    private boolean generateUniqueName;
    private String url;
    private String username;
    private String password;
    private Map<String, String> properties;
    private Pool pool = new Pool();
    private EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.NONE;
    private String uniqueName;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() {
        this.embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String determineUrl() {
        String url;
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        String databaseName = this.determineDatabaseName();
        String string = url = databaseName != null ? this.embeddedDatabaseConnection.getUrl(databaseName) : null;
        if (!StringUtils.hasText((String)url)) {
            throw new DataSourceBeanCreationException("Failed to determine suitable R2DBC url", this, this.embeddedDatabaseConnection);
        }
        return url;
    }

    public String determineDatabaseName() {
        if (this.generateUniqueName) {
            if (this.uniqueName == null) {
                this.uniqueName = UUID.randomUUID().toString();
            }
            return this.uniqueName;
        }
        if (StringUtils.hasLength((String)this.name)) {
            return this.name;
        }
        if (this.embeddedDatabaseConnection != EmbeddedDatabaseConnection.NONE) {
            return "testdb";
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String determineUsername() {
        if (StringUtils.hasText((String)this.username)) {
            return this.username;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.determineDriverName())) {
            return "sa";
        }
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String determinePassword() {
        if (StringUtils.hasText((String)this.password)) {
            return this.password;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.determineDriverName())) {
            return "";
        }
        return null;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    private String determineDriverName() {
        if (this.embeddedDatabaseConnection != EmbeddedDatabaseConnection.NONE) {
            return this.embeddedDatabaseConnection.getType().name().toLowerCase();
        }
        if (StringUtils.hasText((String)this.url)) {
            return (String)ConnectionFactoryOptions.parse((CharSequence)this.url).getRequiredValue(ConnectionFactoryOptions.DRIVER);
        }
        throw new DataSourceBeanCreationException("Failed to determine a suitable driver", this, this.embeddedDatabaseConnection);
    }

    static class Pool {
        private Duration maxIdleTime = Duration.ofMinutes(30L);
        private int initialSize = 10;
        private int maxSize = 10;
        private String validationQuery;

        Pool() {
        }

        public Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public int getInitialSize() {
            return this.initialSize;
        }

        public void setInitialSize(int initialSize) {
            this.initialSize = initialSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }
    }

    static class DataSourceBeanCreationException
    extends BeanCreationException {
        private final R2dbcProperties properties;
        private final EmbeddedDatabaseConnection connection;

        DataSourceBeanCreationException(String message, R2dbcProperties properties, EmbeddedDatabaseConnection connection) {
            super(message);
            this.properties = properties;
            this.connection = connection;
        }

        public R2dbcProperties getProperties() {
            return this.properties;
        }

        public EmbeddedDatabaseConnection getConnection() {
            return this.connection;
        }
    }
}

