/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction.reactive;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.data.r2dbc.R2dbcTransactionManagerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.reactive.TransactionalOperator;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveTransactionManager.class})
@AutoConfigureAfter(value={R2dbcTransactionManagerAutoConfiguration.class})
public class ReactiveTransactionAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=ReactiveTransactionManager.class)
    static class TransactionalOperatorConfiguration {
        TransactionalOperatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TransactionalOperator transactionalOperator(ReactiveTransactionManager transactionManager) {
            return TransactionalOperator.create((ReactiveTransactionManager)transactionManager);
        }
    }
}

