/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, RedisClient.class, RedisClusterClient.class})
class LettuceConnectionConfiguration
extends RedisConnectionConfiguration {
    private final RedisProperties properties;
    private final List<LettuceClientConfigurationBuilderCustomizer> builderCustomizers;

    LettuceConnectionConfiguration(RedisProperties properties, ObjectProvider<RedisSentinelConfiguration> sentinelConfigurationProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigurationProvider, ObjectProvider<List<LettuceClientConfigurationBuilderCustomizer>> builderCustomizers) {
        super(properties, sentinelConfigurationProvider, clusterConfigurationProvider);
        this.properties = properties;
        this.builderCustomizers = (List)builderCustomizers.getIfAvailable(Collections::emptyList);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ClientResources.class})
    public DefaultClientResources lettuceClientResources() {
        return DefaultClientResources.create();
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public LettuceConnectionFactory redisConnectionFactory(ClientResources clientResources) throws UnknownHostException {
        LettuceClientConfiguration clientConfig = this.getLettuceClientConfiguration(clientResources, this.properties.getLettuce().getPool());
        return this.createLettuceConnectionFactory(clientConfig);
    }

    private static GenericObjectPoolConfig lettucePoolConfig(RedisProperties.Pool props) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(props.getMaxActive());
        config.setMaxIdle(props.getMaxIdle());
        config.setMinIdle(props.getMinIdle());
        config.setMaxWaitMillis((long)props.getMaxWait());
        return config;
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(LettuceClientConfiguration clientConfiguration) {
        if (this.getSentinelConfig() != null) {
            return new LettuceConnectionFactory(this.getSentinelConfig(), clientConfiguration);
        }
        if (this.getClusterConfiguration() != null) {
            return new LettuceConnectionFactory(this.getClusterConfiguration(), clientConfiguration);
        }
        return new LettuceConnectionFactory(this.getStandaloneConfig(), clientConfiguration);
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(ClientResources clientResources, RedisProperties.Pool pool) {
        Object builder = pool != null ? LettucePoolingClientConfiguration.builder().poolConfig(LettuceConnectionConfiguration.lettucePoolConfig(pool)) : LettuceClientConfiguration.builder();
        this.applyProperties((LettuceClientConfiguration.LettuceClientConfigurationBuilder)builder);
        if (StringUtils.hasText((String)this.properties.getUrl())) {
            this.customizeConfigurationFromUrl((LettuceClientConfiguration.LettuceClientConfigurationBuilder)builder);
        }
        builder.clientResources(clientResources);
        this.customize((LettuceClientConfiguration.LettuceClientConfigurationBuilder)builder);
        return builder.build();
    }

    private LettuceClientConfiguration.LettuceClientConfigurationBuilder applyProperties(LettuceClientConfiguration.LettuceClientConfigurationBuilder builder) {
        RedisProperties.Lettuce lettuce;
        if (this.properties.isSsl()) {
            builder.useSsl();
        }
        if (this.properties.getTimeout() != 0) {
            builder.commandTimeout(Duration.ofMillis(this.properties.getTimeout()));
        }
        if (this.properties.getLettuce() != null && (lettuce = this.properties.getLettuce()).getShutdownTimeout() >= 0) {
            builder.shutdownTimeout(Duration.ofMillis(this.properties.getLettuce().getShutdownTimeout()));
        }
        return builder;
    }

    private void customizeConfigurationFromUrl(LettuceClientConfiguration.LettuceClientConfigurationBuilder builder) {
        RedisConnectionConfiguration.ConnectionInfo connectionInfo = this.parseUrl(this.properties.getUrl());
        if (connectionInfo.isUseSsl()) {
            builder.useSsl();
        }
    }

    private void customize(LettuceClientConfiguration.LettuceClientConfigurationBuilder builder) {
        for (LettuceClientConfigurationBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
    }
}

