/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.batch.JpaBatchConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnClass(value={PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={BatchConfigurer.class})
@Configuration(proxyBeanMethods=false)
class BatchConfigurerConfiguration {
    BatchConfigurerConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EntityManagerFactory.class})
    @ConditionalOnBean(name={"entityManagerFactory"})
    static class JpaBatchConfiguration {
        JpaBatchConfiguration() {
        }

        @Bean
        public JpaBatchConfigurer batchConfigurer(BatchProperties properties, DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, EntityManagerFactory entityManagerFactory) {
            return new JpaBatchConfigurer(properties, dataSource, (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable(), entityManagerFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(name={"entityManagerFactory"})
    static class JdbcBatchConfiguration {
        JdbcBatchConfiguration() {
        }

        @Bean
        public BasicBatchConfigurer batchConfigurer(BatchProperties properties, DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            return new BasicBatchConfigurer(properties, dataSource, (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable());
        }
    }
}

