/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JdbcTemplate.class, PlatformTransactionManager.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class DataSourceTransactionManagerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=DataSource.class)
    static class DataSourceTransactionManagerConfiguration {
        DataSourceTransactionManagerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
        public DataSourceTransactionManager transactionManager(DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
            transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
            return transactionManager;
        }
    }
}

