/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.artemis;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.TopicConfigurationImpl;
import org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConfigurationCustomizer;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisEmbeddedConfigurationFactory;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisNoOpBindingRegistry;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EmbeddedJMS.class})
@ConditionalOnProperty(prefix="spring.artemis.embedded", name={"enabled"}, havingValue="true", matchIfMissing=true)
class ArtemisEmbeddedServerConfiguration {
    private final ArtemisProperties properties;

    ArtemisEmbeddedServerConfiguration(ArtemisProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Configuration artemisConfiguration() {
        return new ArtemisEmbeddedConfigurationFactory(this.properties).createConfiguration();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public EmbeddedJMS artemisServer(Configuration configuration, JMSConfiguration jmsConfiguration, ObjectProvider<ArtemisConfigurationCustomizer> configurationCustomizers) {
        EmbeddedJMS server = new EmbeddedJMS();
        configurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
        server.setConfiguration(configuration);
        server.setJmsConfiguration(jmsConfiguration);
        server.setRegistry((BindingRegistry)new ArtemisNoOpBindingRegistry());
        return server;
    }

    @Bean
    @ConditionalOnMissingBean
    public JMSConfiguration artemisJmsConfiguration(ObjectProvider<JMSQueueConfiguration> queuesConfiguration, ObjectProvider<TopicConfiguration> topicsConfiguration) {
        JMSConfigurationImpl configuration = new JMSConfigurationImpl();
        this.addAll(configuration.getQueueConfigurations(), queuesConfiguration);
        this.addAll(configuration.getTopicConfigurations(), topicsConfiguration);
        this.addQueues((JMSConfiguration)configuration, this.properties.getEmbedded().getQueues());
        this.addTopics((JMSConfiguration)configuration, this.properties.getEmbedded().getTopics());
        return configuration;
    }

    private <T> void addAll(List<T> list, ObjectProvider<T> items) {
        if (items != null) {
            list.addAll(items.orderedStream().collect(Collectors.toList()));
        }
    }

    private void addQueues(JMSConfiguration configuration, String[] queues) {
        boolean persistent = this.properties.getEmbedded().isPersistent();
        for (String queue : queues) {
            JMSQueueConfigurationImpl jmsQueueConfiguration = new JMSQueueConfigurationImpl();
            jmsQueueConfiguration.setName(queue);
            jmsQueueConfiguration.setDurable(persistent);
            jmsQueueConfiguration.setBindings(new String[]{"/queue/" + queue});
            configuration.getQueueConfigurations().add(jmsQueueConfiguration);
        }
    }

    private void addTopics(JMSConfiguration configuration, String[] topics) {
        for (String topic : topics) {
            TopicConfigurationImpl topicConfiguration = new TopicConfigurationImpl();
            topicConfiguration.setName(topic);
            topicConfiguration.setBindings(new String[]{"/topic/" + topic});
            configuration.getTopicConfigurations().add(topicConfiguration);
        }
    }
}

