/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.transport.netty.server.TcpServerTransport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.rsocket.RSocketStrategiesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.rsocket.MessageHandlerAcceptor;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RSocketRequester.class, RSocketFactory.class, TcpServerTransport.class})
@AutoConfigureAfter(value={RSocketStrategiesAutoConfiguration.class})
public class RSocketMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessageHandlerAcceptor messageHandlerAcceptor(RSocketStrategies rSocketStrategies) {
        MessageHandlerAcceptor acceptor = new MessageHandlerAcceptor();
        acceptor.setRSocketStrategies(rSocketStrategies);
        return acceptor;
    }
}

