/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.undertow.UndertowOptions;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;
import org.xnio.Option;

public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableUndertowWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public UndertowWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableUndertowWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.Undertow undertowProperties = properties.getUndertow();
        ServerProperties.Undertow.Accesslog accesslogProperties = undertowProperties.getAccesslog();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(undertowProperties::getBufferSize).whenNonNull().asInt(DataSize::toBytes).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setBufferSize(arg_0));
        propertyMapper.from(undertowProperties::getIoThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setIoThreads(arg_0));
        propertyMapper.from(undertowProperties::getWorkerThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setWorkerThreads(arg_0));
        propertyMapper.from(undertowProperties::getDirectBuffers).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseDirectBuffers(arg_0));
        propertyMapper.from(accesslogProperties::isEnabled).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogEnabled(arg_0));
        propertyMapper.from(accesslogProperties::getDir).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogDirectory(arg_0));
        propertyMapper.from(accesslogProperties::getPattern).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPattern(arg_0));
        propertyMapper.from(accesslogProperties::getPrefix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPrefix(arg_0));
        propertyMapper.from(accesslogProperties::getSuffix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogSuffix(arg_0));
        propertyMapper.from(accesslogProperties::isRotate).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogRotate(arg_0));
        propertyMapper.from(this::getOrDeduceUseForwardHeaders).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseForwardHeaders(arg_0));
        propertyMapper.from(properties::getMaxHttpHeaderSize).whenNonNull().asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeServerOption(factory, UndertowOptions.MAX_HEADER_SIZE, maxHttpHeaderSize));
        propertyMapper.from(undertowProperties::getMaxHttpPostSize).as(DataSize::toBytes).when(this::isPositive).to(maxHttpPostSize -> this.customizeServerOption(factory, UndertowOptions.MAX_ENTITY_SIZE, maxHttpPostSize));
        propertyMapper.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeServerOption(factory, UndertowOptions.NO_REQUEST_TIMEOUT, (int)connectionTimeout.toMillis()));
        propertyMapper.from(undertowProperties::getMaxParameters).to(maxParameters -> this.customizeServerOption(factory, UndertowOptions.MAX_PARAMETERS, maxParameters));
        propertyMapper.from(undertowProperties::getMaxHeaders).to(maxHeaders -> this.customizeServerOption(factory, UndertowOptions.MAX_HEADERS, maxHeaders));
        propertyMapper.from(undertowProperties::getMaxCookies).to(maxCookies -> this.customizeServerOption(factory, UndertowOptions.MAX_COOKIES, maxCookies));
        propertyMapper.from(undertowProperties::isAllowEncodedSlash).to(allowEncodedSlash -> this.customizeServerOption(factory, UndertowOptions.ALLOW_ENCODED_SLASH, allowEncodedSlash));
        propertyMapper.from(undertowProperties::isDecodeUrl).to(isDecodeUrl -> this.customizeServerOption(factory, UndertowOptions.DECODE_URL, isDecodeUrl));
        propertyMapper.from(undertowProperties::getUrlCharset).to(urlCharset -> this.customizeServerOption(factory, UndertowOptions.URL_CHARSET, urlCharset.name()));
        propertyMapper.from(undertowProperties::isAlwaysSetKeepAlive).to(alwaysSetKeepAlive -> this.customizeServerOption(factory, UndertowOptions.ALWAYS_SET_KEEP_ALIVE, alwaysSetKeepAlive));
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.setEagerFilterInit(undertowProperties.isEagerFilterInit())});
    }

    private boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private <T> void customizeServerOption(ConfigurableUndertowWebServerFactory factory, Option<T> option, T value) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(option, value)});
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NONE)) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }
}

