/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportMessage;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

class ConditionEvaluationDeltaLoggingListener
implements ApplicationListener<ApplicationReadyEvent> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static ConditionEvaluationReport previousReport;

    ConditionEvaluationDeltaLoggingListener() {
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConditionEvaluationReport report = (ConditionEvaluationReport)event.getApplicationContext().getBean(ConditionEvaluationReport.class);
        if (previousReport != null) {
            ConditionEvaluationReport delta = report.getDelta(previousReport);
            if (!(delta.getConditionAndOutcomesBySource().isEmpty() && delta.getExclusions().isEmpty() && delta.getUnconditionalClasses().isEmpty())) {
                this.logger.info((Object)("Condition evaluation delta:" + new ConditionEvaluationReportMessage(delta, "CONDITION EVALUATION DELTA")));
            } else {
                this.logger.info((Object)"Condition evaluation unchanged");
            }
        }
        previousReport = report;
    }
}

