/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.net.URL;
import java.net.URLClassLoader;

public final class HidePackagesClassLoader
extends URLClassLoader {
    private final String[] hiddenPackages;

    public HidePackagesClassLoader(String ... hiddenPackages) {
        super(new URL[0], HidePackagesClassLoader.class.getClassLoader());
        this.hiddenPackages = hiddenPackages;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String hiddenPackage : this.hiddenPackages) {
            if (!name.startsWith(hiddenPackage)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }
}

