/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.ArrayBinder;
import org.springframework.boot.context.properties.bind.BeanBinder;
import org.springframework.boot.context.properties.bind.BeanPropertyBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.CollectionBinder;
import org.springframework.boot.context.properties.bind.JavaBeanBinder;
import org.springframework.boot.context.properties.bind.MapBinder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.ResolvableTypeDescriptor;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Binder {
    private static final Set<Class<?>> NON_BEAN_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Object.class, Class.class)));
    private static final List<BeanBinder> beanBinders;
    private final Iterable<ConfigurationPropertySource> sources;
    private final PlaceholdersResolver placeholdersResolver;
    private final BinderConversionService conversionService;

    public Binder(ConfigurationPropertySource ... sources) {
        this(Arrays.asList(sources), null, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources) {
        this(sources, null, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver) {
        this(sources, placeholdersResolver, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, ConversionService conversionService) {
        Assert.notNull(sources, (String)"Sources must not be null");
        this.sources = sources;
        this.placeholdersResolver = placeholdersResolver != null ? placeholdersResolver : PlaceholdersResolver.NONE;
        this.conversionService = conversionService instanceof BinderConversionService ? (BinderConversionService)conversionService : new BinderConversionService(conversionService);
    }

    public <T> BindResult<T> bind(String name, Class<T> target) {
        return this.bind(name, Bindable.of(target));
    }

    public <T> BindResult<T> bind(String name, Bindable<T> target) {
        return this.bind(ConfigurationPropertyName.of(name), target, null);
    }

    public <T> BindResult<T> bind(ConfigurationPropertyName name, Bindable<T> target) {
        return this.bind(name, target, null);
    }

    public <T> BindResult<T> bind(String name, Bindable<T> target, BindHandler handler) {
        return this.bind(ConfigurationPropertyName.of(name), target, handler);
    }

    public <T> BindResult<T> bind(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(target, (String)"Target must not be null");
        handler = handler != null ? handler : BindHandler.DEFAULT;
        Context context = new Context();
        T bound = this.bind(name, target, handler, context, false);
        return BindResult.of(bound);
    }

    protected final <T> T bind(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, boolean allowRecursiveBinding) {
        context.clearConfigurationProperty();
        try {
            if (!handler.onStart(name, target, context)) {
                return null;
            }
            Object bound = this.bindObject(name, target, handler, context, allowRecursiveBinding);
            return this.handleBindResult(name, target, handler, context, bound);
        }
        catch (Exception ex) {
            return this.handleBindError(name, target, handler, context, ex);
        }
    }

    private <T> T handleBindResult(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, Object result) throws Exception {
        if (result != null) {
            result = handler.onSuccess(name, target, context, result);
            result = this.convert(result, target);
        }
        handler.onFinish(name, target, context, result);
        return this.convert(result, target);
    }

    private <T> T handleBindError(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, Exception error) {
        try {
            Object result = handler.onFailure(name, target, context, error);
            return this.convert(result, target);
        }
        catch (Exception ex) {
            if (ex instanceof BindException) {
                throw (BindException)ex;
            }
            throw new BindException(name, target, context.getConfigurationProperty(), ex);
        }
    }

    private <T> T convert(Object value, Bindable<T> target) {
        return ResolvableTypeDescriptor.forBindable(target).convert(this.conversionService, value);
    }

    private <T> Object bindObject(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, boolean allowRecursiveBinding) throws Exception {
        ConfigurationProperty property = this.findProperty(name, context);
        if (property == null && this.containsNoDescendantOf(context.streamSources(), name)) {
            return null;
        }
        AggregateBinder<?> aggregateBinder = this.getAggregateBinder(target, context);
        if (aggregateBinder != null) {
            return this.bindAggregate(name, target, handler, context, aggregateBinder);
        }
        if (property != null) {
            try {
                return this.bindProperty(name, target, handler, context, property);
            }
            catch (ConverterNotFoundException ex) {
                Object bean = this.bindBean(name, target, handler, context, allowRecursiveBinding);
                if (bean != null) {
                    return bean;
                }
                throw ex;
            }
        }
        return this.bindBean(name, target, handler, context, allowRecursiveBinding);
    }

    private AggregateBinder<?> getAggregateBinder(Bindable<?> target, Context context) {
        Class resolvedType = target.getType().resolve();
        if (Map.class.isAssignableFrom(resolvedType)) {
            return new MapBinder(context);
        }
        if (Collection.class.isAssignableFrom(resolvedType)) {
            return new CollectionBinder(context);
        }
        if (target.getType().isArray()) {
            return new ArrayBinder(context);
        }
        return null;
    }

    private <T> Object bindAggregate(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, AggregateBinder<?> aggregateBinder) {
        AggregateElementBinder elementBinder = (itemName, itemTarget, source) -> {
            boolean allowRecursiveBinding = aggregateBinder.isAllowRecursiveBinding(source);
            Supplier<Object> supplier = () -> this.bind(itemName, itemTarget, handler, context, allowRecursiveBinding);
            return context.withSource(source, supplier);
        };
        return context.withIncreasedDepth(() -> aggregateBinder.bind(name, target, elementBinder));
    }

    private ConfigurationProperty findProperty(ConfigurationPropertyName name, Context context) {
        return context.streamSources().map(source -> source.getConfigurationProperty(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private <T> Object bindProperty(ConfigurationPropertyName name, Bindable<T> target, BindHandler handler, Context context, ConfigurationProperty property) {
        context.setConfigurationProperty(property);
        Object result = property.getValue();
        result = this.placeholdersResolver.resolvePlaceholders(result);
        result = this.convert(result, target);
        return result;
    }

    private Object bindBean(ConfigurationPropertyName name, Bindable<?> target, BindHandler handler, Context context, boolean allowRecursiveBinding) {
        if (this.containsNoDescendantOf(context.streamSources(), name) || this.isUnbindableBean(name, target, context)) {
            return null;
        }
        BeanPropertyBinder propertyBinder = (propertyName, propertyTarget) -> this.bind(name.append(propertyName), propertyTarget, handler, context, false);
        Class type = target.getType().resolve();
        if (!allowRecursiveBinding && context.hasBoundBean(type)) {
            return null;
        }
        return context.withBean(type, () -> {
            Stream<Object> boundBeans = beanBinders.stream().map(b -> b.bind(name, target, context, propertyBinder));
            return boundBeans.filter(Objects::nonNull).findFirst().orElse(null);
        });
    }

    private boolean isUnbindableBean(ConfigurationPropertyName name, Bindable<?> target, Context context) {
        if (context.streamSources().anyMatch(s -> s.containsDescendantOf(name) == ConfigurationPropertyState.PRESENT)) {
            return false;
        }
        Class resolved = target.getType().resolve();
        if (resolved.isPrimitive() || NON_BEAN_CLASSES.contains(resolved)) {
            return true;
        }
        String packageName = ClassUtils.getPackageName((Class)resolved);
        return packageName.startsWith("java.");
    }

    private boolean containsNoDescendantOf(Stream<ConfigurationPropertySource> sources, ConfigurationPropertyName name) {
        return sources.allMatch(s -> s.containsDescendantOf(name) == ConfigurationPropertyState.ABSENT);
    }

    public static Binder get(Environment environment) {
        return new Binder(ConfigurationPropertySources.get(environment), new PropertySourcesPlaceholdersResolver(environment));
    }

    static {
        ArrayList<JavaBeanBinder> binders = new ArrayList<JavaBeanBinder>();
        binders.add(new JavaBeanBinder());
        beanBinders = Collections.unmodifiableList(binders);
    }

    final class Context
    implements BindContext {
        private int depth;
        private int sourcePushCount;
        private final List<ConfigurationPropertySource> source = Arrays.asList(new ConfigurationPropertySource[]{null});
        private final Deque<Class<?>> beans = new ArrayDeque();
        private ConfigurationProperty configurationProperty;

        Context() {
        }

        void increaseDepth() {
            ++this.depth;
        }

        void decreaseDepth() {
            --this.depth;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T withSource(ConfigurationPropertySource source, Supplier<T> supplier) {
            if (source == null) {
                return supplier.get();
            }
            this.source.set(0, source);
            ++this.sourcePushCount;
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                --this.sourcePushCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T withBean(Class<?> bean, Supplier<T> supplier) {
            this.beans.push(bean);
            try {
                T t = this.withIncreasedDepth(supplier);
                return t;
            }
            finally {
                this.beans.pop();
            }
        }

        public <T> T withIncreasedDepth(Supplier<T> supplier) {
            this.increaseDepth();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.decreaseDepth();
            }
        }

        @Override
        public Iterable<ConfigurationPropertySource> getSources() {
            if (this.sourcePushCount > 0) {
                return this.source;
            }
            return Binder.this.sources;
        }

        @Override
        public Stream<ConfigurationPropertySource> streamSources() {
            if (this.sourcePushCount > 0) {
                return this.source.stream();
            }
            return StreamSupport.stream(Binder.this.sources.spliterator(), false);
        }

        public boolean hasBoundBean(Class<?> bean) {
            return this.beans.contains(bean);
        }

        @Override
        public ConfigurationProperty getConfigurationProperty() {
            return this.configurationProperty;
        }

        void setConfigurationProperty(ConfigurationProperty configurationProperty) {
            this.configurationProperty = configurationProperty;
        }

        void clearConfigurationProperty() {
            this.configurationProperty = null;
        }

        @Override
        public PlaceholdersResolver getPlaceholdersResolver() {
            return Binder.this.placeholdersResolver;
        }

        @Override
        public BinderConversionService getConversionService() {
            return Binder.this.conversionService;
        }
    }
}

