/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.server;

import io.rsocket.SocketAcceptor;
import org.springframework.boot.rsocket.context.RSocketServerInitializedEvent;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;

public class RSocketServerBootstrap
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private final RSocketServer rSocketServer;
    private ApplicationEventPublisher applicationEventPublisher;

    public RSocketServerBootstrap(RSocketServerFactory serverFactoryProvider, SocketAcceptor socketAcceptor) {
        this.rSocketServer = serverFactoryProvider.create(socketAcceptor);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void start() {
        this.rSocketServer.start();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RSocketServerInitializedEvent(this.rSocketServer));
    }

    public void stop() {
        this.rSocketServer.stop();
    }

    public boolean isRunning() {
        RSocketServer server = this.rSocketServer;
        if (server != null) {
            return server.address() != null;
        }
        return false;
    }
}

