/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.file;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ResourcesFileSource
implements FileSource {
    private final FileSource[] sources;

    public ResourcesFileSource(Resource ... resources) {
        this(ResourcesFileSource.toSources(resources));
    }

    private ResourcesFileSource(FileSource ... sources) {
        this.sources = sources;
    }

    private static FileSource[] toSources(Resource[] resources) {
        FileSource[] sources = new FileSource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            if (resource instanceof ClassPathResource) {
                ClassPathResource classes = (ClassPathResource)resource;
                sources[i] = new ClasspathFileSource(classes.getPath());
                continue;
            }
            if (resource instanceof FileSystemResource) {
                FileSystemResource files = (FileSystemResource)resource;
                sources[i] = new SingleRootFileSource(files.getFile());
                continue;
            }
            throw new IllegalArgumentException("Unsupported resource type for file source: " + resource.getClass());
        }
        return sources;
    }

    public BinaryFile getBinaryFileNamed(String name) {
        for (FileSource resource : this.sources) {
            try {
                UrlResource uri = new UrlResource(resource.getBinaryFileNamed(name).getUri());
                if (!uri.exists()) continue;
                return resource.getBinaryFileNamed(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot create file for " + name);
    }

    public TextFile getTextFileNamed(String name) {
        for (FileSource resource : this.sources) {
            TextFile file = resource.getTextFileNamed(name);
            try {
                file.readContentsAsString();
                return file;
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }

    public void createIfNecessary() {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public FileSource child(String subDirectoryName) {
        ArrayList<FileSource> childSources = new ArrayList<FileSource>();
        for (FileSource resource : this.sources) {
            try {
                UrlResource uri = new UrlResource(resource.child(subDirectoryName).getUri());
                if (!uri.createRelative(subDirectoryName).exists()) continue;
                childSources.add(resource.child(subDirectoryName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!childSources.isEmpty()) {
            return new ResourcesFileSource(childSources.toArray(new FileSource[0]));
        }
        return this.sources[0].child(subDirectoryName);
    }

    public String getPath() {
        for (FileSource resource : this.sources) {
            try {
                UrlResource uri = new UrlResource(resource.getUri());
                if (!uri.exists()) continue;
                return resource.getPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sources[0].getPath();
    }

    public URI getUri() {
        for (FileSource resource : this.sources) {
            try {
                UrlResource uri = new UrlResource(resource.getUri());
                if (!uri.exists()) continue;
                return resource.getUri();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sources[0].getUri();
    }

    public List<TextFile> listFilesRecursively() {
        ArrayList<TextFile> files = new ArrayList<TextFile>();
        for (FileSource resource : this.sources) {
            files.addAll(resource.listFilesRecursively());
        }
        return files;
    }

    public void writeTextFile(String name, String contents) {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public void writeBinaryFile(String name, byte[] contents) {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public boolean exists() {
        for (FileSource resource : this.sources) {
            if (!resource.exists()) continue;
            return true;
        }
        return false;
    }

    public void deleteFile(String name) {
    }
}

