/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.feign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.netflix.feign.ribbon.FeignRibbonClientAutoConfiguration;
import org.springframework.cloud.netflix.feign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependency;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnDependenciesPassed
@ConditionalOnProperty(value={"spring.cloud.zookeeper.dependency.headers.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Client.class, LoadBalancerFeignClient.class})
@AutoConfigureAfter(value={RibbonAutoConfiguration.class, FeignRibbonClientAutoConfiguration.class})
public class DependencyFeignClientAutoConfiguration {
    @Autowired(required=false)
    private LoadBalancerFeignClient ribbonClient;
    @Autowired
    private ZookeeperDependencies zookeeperDependencies;
    @Autowired
    private CachingSpringLoadBalancerFactory loadBalancerFactory;
    @Autowired
    private SpringClientFactory springClientFactory;

    @Bean
    @Primary
    Client dependencyBasedFeignClient() {
        return new LoadBalancerFeignClient((Client)new Client.Default(null, null), this.loadBalancerFactory, this.springClientFactory){

            public Response execute(Request request, Request.Options options) throws IOException {
                URI asUri = URI.create(request.url());
                String clientName = asUri.getHost();
                ZookeeperDependency dependencyForAlias = DependencyFeignClientAutoConfiguration.this.zookeeperDependencies.getDependencyForAlias(clientName);
                Map<String, Collection<String>> headers = this.getUpdatedHeadersIfPossible(request, dependencyForAlias);
                if (DependencyFeignClientAutoConfiguration.this.ribbonClient != null) {
                    return DependencyFeignClientAutoConfiguration.this.ribbonClient.execute(this.request(request, headers), options);
                }
                return super.execute(this.request(request, headers), options);
            }

            private Request request(Request request, Map<String, Collection<String>> headers) {
                return Request.create((String)request.method(), (String)request.url(), headers, (byte[])request.body(), (Charset)request.charset());
            }

            private Map<String, Collection<String>> getUpdatedHeadersIfPossible(Request request, ZookeeperDependency dependencyForAlias) {
                if (dependencyForAlias != null) {
                    return Collections.unmodifiableMap(new HashMap<String, Collection<String>>(dependencyForAlias.getUpdatedHeaders(request.headers())));
                }
                return request.headers();
            }
        };
    }
}

