/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class EntityOperations {
    private static final String ID_FIELD = "_id";
    @NonNull
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context;

    public <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return MappedEntity.of(entity, this.context);
    }

    public <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return AdaptibleMappedEntity.of(entity, this.context, conversionService);
    }

    public String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        return ((MongoPersistentEntity)this.context.getRequiredPersistentEntity(entityClass)).getCollection();
    }

    @Nullable
    public String determineEntityCollectionName(@Nullable Object obj) {
        return null == obj ? null : this.determineCollectionName(obj.getClass());
    }

    public Query getByIdInQuery(Collection<?> entities) {
        LinkedMultiValueMap byIds = new LinkedMultiValueMap();
        entities.stream().map(this::forEntity).forEach(arg_0 -> EntityOperations.lambda$getByIdInQuery$0((MultiValueMap)byIds, arg_0));
        Criteria[] criterias = (Criteria[])byIds.entrySet().stream().map(it -> Criteria.where((String)it.getKey()).in((Collection)it.getValue())).toArray(Criteria[]::new);
        return new Query(criterias.length == 1 ? criterias[0] : new Criteria().orOperator(criterias));
    }

    public String getIdPropertyName(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(type);
        if (persistentEntity != null && persistentEntity.getIdProperty() != null) {
            return ((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getName();
        }
        return ID_FIELD;
    }

    private static Document parse(String source) {
        try {
            return Document.parse((String)source);
        }
        catch (JsonParseException o_O) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)o_O);
        }
        catch (RuntimeException o_O) {
            if (ClassUtils.matchesTypeName(o_O.getClass(), (String)"JSONParseException")) {
                throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)o_O);
            }
            throw o_O;
        }
    }

    public EntityOperations(@NonNull MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
        if (context == null) {
            throw new IllegalArgumentException("context is marked @NonNull but is null");
        }
        this.context = context;
    }

    private static /* synthetic */ void lambda$getByIdInQuery$0(MultiValueMap byIds, Entity it) {
        byIds.add((Object)it.getIdFieldName(), it.getId());
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final MongoPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;

        private AdaptibleMappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor) {
            super(entity, identifierAccessor, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
        }

        private static <T> AdaptibleEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, ConversionService conversionService) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptibleMappedEntity<T>(entity, identifierAccessor, new ConvertingPropertyAccessor(propertyAccessor, conversionService));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return null;
            }
            Object bean = this.propertyAccessor.getBean();
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)bean;
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)bean;
            }
            this.propertyAccessor.setProperty((PersistentProperty)idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        @Nullable
        public Number getVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return (Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        }

        @Override
        public T initializeVersionProperty() {
            MongoPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        @NonNull
        private final MongoPersistentEntity<?> entity;
        @NonNull
        private final IdentifierAccessor idAccessor;
        @NonNull
        private final PersistentPropertyAccessor<T> propertyAccessor;

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor);
        }

        @Override
        public String getIdFieldName() {
            return ((MongoPersistentProperty)this.entity.getRequiredIdProperty()).getFieldName();
        }

        @Override
        public Object getId() {
            return this.idAccessor.getRequiredIdentifier();
        }

        @Override
        public Query getByIdQuery() {
            if (!this.entity.hasIdProperty()) {
                throw new MappingException("No id property found for object of type " + this.entity.getType() + "!");
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            return Query.query(Criteria.where(idProperty.getName()).is(this.getId()));
        }

        @Override
        public Query getQueryForVersion() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return new Query(Criteria.where(idProperty.getName()).is(this.getId()).and(versionProperty.getName()).is(this.getVersion()));
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean = this.propertyAccessor.getBean();
            Document document = new Document();
            writer.write(bean, document);
            if (document.containsKey((Object)EntityOperations.ID_FIELD) && document.get((Object)EntityOperations.ID_FIELD) == null) {
                document.remove((Object)EntityOperations.ID_FIELD);
            }
            return MappedDocument.of(document);
        }

        @Override
        public void assertUpdateableIdIfNotSet() {
            if (!this.entity.hasIdProperty()) {
                return;
            }
            MongoPersistentProperty property = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            Object propertyValue = this.idAccessor.getIdentifier();
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", property.getType().getName(), this.entity.getType().getName()));
            }
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        @Nullable
        public Object getVersion() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredVersionProperty());
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }

        protected MappedEntity(@NonNull MongoPersistentEntity<?> entity, @NonNull IdentifierAccessor idAccessor, @NonNull PersistentPropertyAccessor<T> propertyAccessor) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked @NonNull but is null");
            }
            if (idAccessor == null) {
                throw new IllegalArgumentException("idAccessor is marked @NonNull but is null");
            }
            if (propertyAccessor == null) {
                throw new IllegalArgumentException("propertyAccessor is marked @NonNull but is null");
            }
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
        }
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends UnmappedEntity<T> {
        SimpleMappedEntity(T map) {
            super(map);
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean = this.getBean();
            bean = bean instanceof Document ? (Document)bean : new Document((Map)bean);
            Document document = new Document();
            writer.write(bean, document);
            return MappedDocument.of(document);
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    implements AdaptibleEntity<T> {
        private final T map;

        @Override
        public String getIdFieldName() {
            return EntityOperations.ID_FIELD;
        }

        @Override
        public Object getId() {
            return this.map.get(EntityOperations.ID_FIELD);
        }

        @Override
        public Query getByIdQuery() {
            return Query.query(Criteria.where(EntityOperations.ID_FIELD).is(this.map.get(EntityOperations.ID_FIELD)));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)EntityOperations.ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public Query getQueryForVersion() {
            throw new MappingException("Cannot query for version on plain Documents!");
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            return MappedDocument.of(this.map instanceof Document ? (Document)this.map : new Document(this.map));
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        @Nullable
        public Number getVersion() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(EntityOperations.ID_FIELD) != null;
        }

        public UnmappedEntity(T map) {
            this.map = map;
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        @Nullable
        public T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        @Nullable
        public Number getVersion();
    }

    static interface Entity<T> {
        public String getIdFieldName();

        public Object getId();

        public Query getByIdQuery();

        default public Query getRemoveByQuery() {
            return this.isVersionedEntity() ? this.getQueryForVersion() : this.getByIdQuery();
        }

        public Query getQueryForVersion();

        public MappedDocument toMappedDocument(MongoWriter<? super T> var1);

        default public void assertUpdateableIdIfNotSet() {
        }

        default public boolean isVersionedEntity() {
            return false;
        }

        @Nullable
        public Object getVersion();

        public T getBean();

        public boolean isNew();
    }
}

