/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.JustOnceLogger;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperationsProvider;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.util.MongoDbErrorCodes;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveMongoPersistentEntityIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMongoPersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final MongoMappingContext mappingContext;
    private final ReactiveIndexOperationsProvider operationsProvider;
    private final IndexResolver indexResolver;

    public ReactiveMongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, ReactiveIndexOperationsProvider operationsProvider) {
        this(mappingContext, operationsProvider, IndexResolver.create(mappingContext));
    }

    public ReactiveMongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, ReactiveIndexOperationsProvider operationsProvider, IndexResolver indexResolver) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MongoMappingContext must not be null!");
        Assert.notNull((Object)operationsProvider, (String)"ReactiveIndexOperations must not be null!");
        Assert.notNull((Object)indexResolver, (String)"IndexResolver must not be null!");
        this.mappingContext = mappingContext;
        this.operationsProvider = operationsProvider;
        this.indexResolver = indexResolver;
    }

    public boolean isIndexCreatorFor(MappingContext<?, ?> context) {
        return ((Object)((Object)this.mappingContext)).equals(context);
    }

    public Mono<Void> checkForIndexes(MongoPersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type) && this.classesSeen.put(type, Boolean.TRUE) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzing class " + type + " for index information.");
            }
            return this.checkForAndCreateIndexes(entity);
        }
        return Mono.empty();
    }

    private Mono<Void> checkForAndCreateIndexes(MongoPersistentEntity<?> entity) {
        ArrayList<Mono<String>> publishers = new ArrayList<Mono<String>>();
        if (entity.isAnnotationPresent(Document.class)) {
            for (IndexDefinition indexDefinition : this.indexResolver.resolveIndexFor(entity.getTypeInformation())) {
                MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexToCreate = indexDefinition instanceof MongoPersistentEntityIndexResolver.IndexDefinitionHolder ? (MongoPersistentEntityIndexResolver.IndexDefinitionHolder)indexDefinition : new MongoPersistentEntityIndexResolver.IndexDefinitionHolder("", indexDefinition, entity.getCollection());
                publishers.add(this.createIndex(indexToCreate));
            }
        }
        return publishers.isEmpty() ? Mono.empty() : Flux.merge(publishers).then();
    }

    Mono<String> createIndex(MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        JustOnceLogger.logWarnIndexCreationConfigurationChange(this.getClass().getName());
        return this.operationsProvider.indexOps(indexDefinition.getCollection()).ensureIndex(indexDefinition).onErrorResume(ReactiveMongoPersistentEntityIndexCreator::isDataIntegrityViolation, e -> this.translateException((Throwable)e, indexDefinition));
    }

    private Mono<? extends String> translateException(Throwable e, MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        Mono<IndexInfo> existingIndex = this.fetchIndexInformation(indexDefinition);
        Mono defaultError = Mono.error((Throwable)new DataIntegrityViolationException(String.format("Cannot create index for '%s' in collection '%s' with keys '%s' and options '%s'.", indexDefinition.getPath(), indexDefinition.getCollection(), indexDefinition.getIndexKeys(), indexDefinition.getIndexOptions()), e.getCause()));
        return existingIndex.flatMap(it -> Mono.error((Throwable)new DataIntegrityViolationException(String.format("Index already defined as '%s'.", indexDefinition.getPath()), e.getCause()))).switchIfEmpty(defaultError);
    }

    private Mono<IndexInfo> fetchIndexInformation(MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        Object indexNameToLookUp = indexDefinition.getIndexOptions().get((Object)"name");
        Flux<IndexInfo> existingIndexes = this.operationsProvider.indexOps(indexDefinition.getCollection()).getIndexInfo();
        return existingIndexes.filter(indexInfo -> ObjectUtils.nullSafeEquals((Object)indexNameToLookUp, (Object)indexInfo.getName())).next().doOnError(e -> LOGGER.debug(String.format("Failed to load index information for collection '%s'.", indexDefinition.getCollection()), e));
    }

    private static boolean isDataIntegrityViolation(Throwable t) {
        if (t instanceof UncategorizedMongoDbException) {
            return t.getCause() instanceof MongoException && MongoDbErrorCodes.isDataIntegrityViolationCode(((MongoException)t.getCause()).getCode());
        }
        return false;
    }
}

