/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.connectionfactory.SmartConnectionFactory;
import reactor.core.publisher.Mono;

class SingletonConnectionFactory
implements SmartConnectionFactory {
    private final ConnectionFactoryMetadata metadata;
    private final Connection connection;
    private final Mono<Connection> connectionMono;
    private final AtomicInteger refCount = new AtomicInteger();

    SingletonConnectionFactory(ConnectionFactoryMetadata metadata, Connection connection) {
        this.metadata = metadata;
        this.connection = connection;
        this.connectionMono = Mono.just((Object)connection);
    }

    public Publisher<? extends Connection> create() {
        if (this.refCount.get() == -1) {
            throw new IllegalStateException("Connection is closed!");
        }
        return this.connectionMono.doOnSubscribe(s -> this.refCount.incrementAndGet());
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.metadata;
    }

    private boolean connectionEquals(Connection connection) {
        return this.connection == connection;
    }

    @Override
    public boolean shouldClose(Connection connection) {
        return this.refCount.get() == 1;
    }

    Mono<Void> close(Connection connection) {
        if (this.connectionEquals(connection)) {
            return Mono.empty().doOnSubscribe(s -> this.refCount.decrementAndGet());
        }
        throw new IllegalArgumentException("Connection is not associated with this connection factory");
    }
}

