/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MappingR2dbcConverter
extends BasicRelationalConverter
implements R2dbcConverter {
    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        super(context, (CustomConversions)new R2dbcCustomConversions(Collections.emptyList()));
    }

    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        super(context, conversions);
    }

    public <R> R read(Class<R> type, Row row) {
        ClassTypeInformation typeInfo = ClassTypeInformation.from(type);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return type.cast(row);
        }
        if (this.getConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        return this.read(this.getRequiredPersistentEntity(type), row);
    }

    private <R> R read(RelationalPersistentEntity<R> entity, Row row) {
        R result = this.createInstance(row, "", entity);
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(result), this.getConversionService());
        for (RelationalPersistentProperty property : entity) {
            Object value;
            if (entity.isConstructorArgument((PersistentProperty)property) || (value = this.readFrom(row, property, "")) == null) continue;
            propertyAccessor.setProperty((PersistentProperty)property, value);
        }
        return result;
    }

    private Object readFrom(Row row, RelationalPersistentProperty property, String prefix) {
        try {
            if (property.isEntity()) {
                return this.readEntityFrom(row, (PersistentProperty<?>)property);
            }
            Object value = row.get((Object)(prefix + property.getColumnName()));
            return this.getPotentiallyConvertedSimpleRead(value, property.getTypeInformation().getType());
        }
        catch (Exception o_O) {
            throw new MappingException(String.format("Could not read property %s from result set!", property), (Throwable)o_O);
        }
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, target);
    }

    private <S> S readEntityFrom(Row row, PersistentProperty<?> property) {
        String prefix = property.getName() + "_";
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property.getActualType());
        if (this.readFrom(row, (RelationalPersistentProperty)entity.getRequiredIdProperty(), prefix) == null) {
            return null;
        }
        S instance = this.createInstance(row, prefix, entity);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(accessor, this.getConversionService());
        for (RelationalPersistentProperty p : entity) {
            if (entity.isConstructorArgument(property)) continue;
            propertyAccessor.setProperty((PersistentProperty)p, this.readFrom(row, p, prefix));
        }
        return instance;
    }

    private <S> S createInstance(Row row, String prefix, RelationalPersistentEntity<S> entity) {
        RowParameterValueProvider rowParameterValueProvider = new RowParameterValueProvider(row, entity, this, prefix);
        return (S)this.createInstance((PersistentEntity)entity, rowParameterValueProvider::getParameterValue);
    }

    public void write(Object source, OutboundRow sink) {
        Class userClass = ClassUtils.getUserClass((Object)source);
        Optional customTarget = this.getConversions().getCustomWriteTarget(userClass, OutboundRow.class);
        if (customTarget.isPresent()) {
            OutboundRow result = (OutboundRow)this.getConversionService().convert(source, OutboundRow.class);
            sink.putAll(result);
            return;
        }
        this.writeInternal(source, sink, userClass);
    }

    private void writeInternal(Object source, OutboundRow sink, Class<?> userClass) {
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(userClass);
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(source);
        this.writeProperties(sink, entity, propertyAccessor);
    }

    private void writeProperties(OutboundRow sink, RelationalPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor) {
        for (RelationalPersistentProperty property : entity) {
            RelationalPersistentEntity nestedEntity;
            if (!property.isWritable()) continue;
            Object value = accessor.getProperty((PersistentProperty)property);
            if (value == null) {
                this.writeNullInternal(sink, property);
                continue;
            }
            if (!this.getConversions().isSimpleType(value.getClass()) && (nestedEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(property.getActualType())) != null) {
                throw new InvalidDataAccessApiUsageException("Nested entities are not supported");
            }
            this.writeSimpleInternal(sink, value, property);
        }
    }

    private void writeSimpleInternal(OutboundRow sink, Object value, RelationalPersistentProperty property) {
        sink.put(property.getColumnName(), SettableValue.from(this.getPotentiallyConvertedSimpleWrite(value)));
    }

    private void writeNullInternal(OutboundRow sink, RelationalPersistentProperty property) {
        sink.put(property.getColumnName(), SettableValue.empty(this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    private Class<?> getPotentiallyConvertedSimpleNullType(Class<?> type) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(type);
        if (customTarget.isPresent()) {
            return (Class)customTarget.get();
        }
        if (type.isEnum()) {
            return String.class;
        }
        return type;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Optional customTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.getConversionService().convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Override
    public Object getArrayValue(ArrayColumns arrayColumns, RelationalPersistentProperty property, Object value) {
        Class<?> targetType = arrayColumns.getArrayType(property.getActualType());
        if (!property.isArray() || !property.getActualType().equals(targetType)) {
            Object zeroLengthArray = Array.newInstance(targetType, 0);
            return this.getConversionService().convert(value, zeroLengthArray.getClass());
        }
        return value;
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> populateIdIfNecessary(T object) {
        Assert.notNull(object, (String)"Entity object must not be null!");
        Class userClass = ClassUtils.getUserClass(object);
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(userClass);
        return (row, metadata) -> {
            RelationalPersistentProperty idProperty;
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
            if (propertyAccessor.getProperty((PersistentProperty)(idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty())) != null) {
                return object;
            }
            return this.potentiallySetId((Row)row, (RowMetadata)metadata, (PersistentPropertyAccessor<?>)propertyAccessor, idProperty) ? propertyAccessor.getBean() : object;
        };
    }

    private boolean potentiallySetId(Row row, RowMetadata metadata, PersistentPropertyAccessor<?> propertyAccessor, RelationalPersistentProperty idProperty) {
        Map<String, ColumnMetadata> columns = MappingR2dbcConverter.createMetadataMap(metadata);
        Object generatedIdValue = null;
        if (columns.containsKey(idProperty.getColumnName())) {
            generatedIdValue = row.get((Object)idProperty.getColumnName());
        }
        if (columns.size() == 1) {
            String key = columns.keySet().iterator().next();
            generatedIdValue = row.get((Object)key);
        }
        if (generatedIdValue == null) {
            return false;
        }
        ConversionService conversionService = this.getConversionService();
        propertyAccessor.setProperty((PersistentProperty)idProperty, conversionService.convert(generatedIdValue, idProperty.getType()));
        return true;
    }

    private <R> RelationalPersistentEntity<R> getRequiredPersistentEntity(Class<R> type) {
        return (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(type);
    }

    private static Map<String, ColumnMetadata> createMetadataMap(RowMetadata metadata) {
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        for (ColumnMetadata column : metadata.getColumnMetadatas()) {
            columns.put(column.getName(), column);
        }
        return columns;
    }

    private static class RowParameterValueProvider
    implements ParameterValueProvider<RelationalPersistentProperty> {
        @NonNull
        private final Row resultSet;
        @NonNull
        private final RelationalPersistentEntity<?> entity;
        @NonNull
        private final RelationalConverter converter;
        @NonNull
        private final String prefix;

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(parameter.getName());
            String column = this.prefix + property.getColumnName();
            try {
                Object value = this.resultSet.get((Object)column);
                if (value == null) {
                    return null;
                }
                return (T)this.converter.getConversionService().convert(value, parameter.getType().getType());
            }
            catch (Exception o_O) {
                throw new MappingException(String.format("Couldn't read column %s from Row.", column), (Throwable)o_O);
            }
        }

        public RowParameterValueProvider(@NonNull Row resultSet, @NonNull RelationalPersistentEntity<?> entity, @NonNull RelationalConverter converter, @NonNull String prefix) {
            if (resultSet == null) {
                throw new IllegalArgumentException("resultSet is marked @NonNull but is null");
            }
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("converter is marked @NonNull but is null");
            }
            if (prefix == null) {
                throw new IllegalArgumentException("prefix is marked @NonNull but is null");
            }
            this.resultSet = resultSet;
            this.entity = entity;
            this.converter = converter;
            this.prefix = prefix;
        }
    }
}

