/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import java.util.function.Consumer;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultDatabaseClient;
import org.springframework.data.r2dbc.core.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.NamedParameterExpander;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.Database;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.support.R2dbcExceptionSubclassTranslator;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultDatabaseClientBuilder
implements DatabaseClient.Builder {
    @Nullable
    private ConnectionFactory connectionFactory;
    @Nullable
    private R2dbcExceptionTranslator exceptionTranslator;
    private ReactiveDataAccessStrategy accessStrategy;
    private NamedParameterExpander namedParameters;

    DefaultDatabaseClientBuilder() {
    }

    DefaultDatabaseClientBuilder(DefaultDatabaseClientBuilder other) {
        Assert.notNull((Object)other, (String)"DefaultDatabaseClientBuilder must not be null!");
        this.connectionFactory = other.connectionFactory;
        this.exceptionTranslator = other.exceptionTranslator;
        this.accessStrategy = other.accessStrategy;
        this.namedParameters = other.namedParameters;
    }

    @Override
    public DatabaseClient.Builder connectionFactory(ConnectionFactory factory) {
        Assert.notNull((Object)factory, (String)"ConnectionFactory must not be null!");
        this.connectionFactory = factory;
        return this;
    }

    @Override
    public DatabaseClient.Builder exceptionTranslator(R2dbcExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"R2dbcExceptionTranslator must not be null!");
        this.exceptionTranslator = exceptionTranslator;
        return this;
    }

    @Override
    public DatabaseClient.Builder dataAccessStrategy(ReactiveDataAccessStrategy accessStrategy) {
        Assert.notNull((Object)accessStrategy, (String)"ReactiveDataAccessStrategy must not be null!");
        this.accessStrategy = accessStrategy;
        return this;
    }

    @Override
    public DatabaseClient.Builder namedParameters(NamedParameterExpander expander) {
        Assert.notNull((Object)expander, (String)"NamedParameterExpander must not be null!");
        this.namedParameters = expander;
        return this;
    }

    @Override
    public DatabaseClient build() {
        NamedParameterExpander namedParameters;
        ReactiveDataAccessStrategy accessStrategy;
        R2dbcExceptionTranslator exceptionTranslator = this.exceptionTranslator;
        if (exceptionTranslator == null) {
            exceptionTranslator = new R2dbcExceptionSubclassTranslator();
        }
        if ((accessStrategy = this.accessStrategy) == null) {
            Dialect dialect = Database.findDatabase(this.connectionFactory).orElseThrow(() -> new UnsupportedOperationException("Cannot determine a Dialect. Configure the dialect by providing DefaultReactiveDataAccessStrategy(Dialect)")).defaultDialect();
            accessStrategy = new DefaultReactiveDataAccessStrategy(dialect);
        }
        if ((namedParameters = this.namedParameters) == null) {
            namedParameters = NamedParameterExpander.enabled();
        }
        return this.doBuild(this.connectionFactory, exceptionTranslator, accessStrategy, namedParameters, new DefaultDatabaseClientBuilder(this));
    }

    protected DatabaseClient doBuild(ConnectionFactory connector, R2dbcExceptionTranslator exceptionTranslator, ReactiveDataAccessStrategy accessStrategy, NamedParameterExpander namedParameters, DefaultDatabaseClientBuilder builder) {
        return new DefaultDatabaseClient(connector, exceptionTranslator, accessStrategy, namedParameters, builder);
    }

    public DatabaseClient.Builder clone() {
        return new DefaultDatabaseClientBuilder(this);
    }

    @Override
    public DatabaseClient.Builder apply(Consumer<DatabaseClient.Builder> builderConsumer) {
        Assert.notNull(builderConsumer, (String)"BuilderConsumer must not be null");
        builderConsumer.accept(this);
        return this;
    }
}

