/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Connection;
import java.util.function.Function;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.r2dbc.core.ConnectionAccessor;
import org.springframework.data.r2dbc.core.FetchSpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultFetchSpec<T>
implements FetchSpec<T> {
    private final ConnectionAccessor connectionAccessor;
    private final String sql;
    private final Function<Connection, Flux<T>> resultFunction;
    private final Function<Connection, Mono<Integer>> updatedRowsFunction;

    @Override
    public Mono<T> one() {
        return this.all().buffer(2).flatMap(it -> {
            if (it.isEmpty()) {
                return Mono.empty();
            }
            if (it.size() > 1) {
                return Mono.error((Throwable)new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result.", this.sql), 1));
            }
            return Mono.just(it.get(0));
        }).next();
    }

    @Override
    public Mono<T> first() {
        return this.all().next();
    }

    @Override
    public Flux<T> all() {
        return this.connectionAccessor.inConnectionMany(this.resultFunction);
    }

    @Override
    public Mono<Integer> rowsUpdated() {
        return this.connectionAccessor.inConnection(this.updatedRowsFunction);
    }

    public DefaultFetchSpec(ConnectionAccessor connectionAccessor, String sql, Function<Connection, Flux<T>> resultFunction, Function<Connection, Mono<Integer>> updatedRowsFunction) {
        this.connectionAccessor = connectionAccessor;
        this.sql = sql;
        this.resultFunction = resultFunction;
        this.updatedRowsFunction = updatedRowsFunction;
    }
}

