/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.EntityRowMapper;
import org.springframework.data.r2dbc.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.core.DefaultStatementMapper;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.UpdateMapper;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.render.NamingStrategies;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultReactiveDataAccessStrategy
implements ReactiveDataAccessStrategy {
    private final Dialect dialect;
    private final R2dbcConverter converter;
    private final UpdateMapper updateMapper;
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    private final StatementMapper statementMapper;

    public DefaultReactiveDataAccessStrategy(Dialect dialect) {
        this(dialect, DefaultReactiveDataAccessStrategy.createConverter(dialect));
    }

    private static R2dbcConverter createConverter(Dialect dialect) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        R2dbcCustomConversions customConversions = new R2dbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), R2dbcCustomConversions.STORE_CONVERTERS), Collections.emptyList());
        RelationalMappingContext context = new RelationalMappingContext();
        context.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return new MappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)context, customConversions);
    }

    public DefaultReactiveDataAccessStrategy(Dialect dialect, R2dbcConverter converter) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        this.converter = converter;
        this.updateMapper = new UpdateMapper(converter);
        this.mappingContext = this.converter.getMappingContext();
        this.dialect = dialect;
        RenderContext renderContext = new RenderContext(){

            public RenderNamingStrategy getNamingStrategy() {
                return NamingStrategies.asIs();
            }

            public SelectRenderContext getSelect() {
                return new SelectRenderContext(){

                    public Function<Select, ? extends CharSequence> afterSelectList() {
                        return it -> "";
                    }

                    public Function<Select, ? extends CharSequence> afterOrderBy(boolean hasOrderBy) {
                        return it -> "";
                    }
                };
            }
        };
        this.statementMapper = new DefaultStatementMapper(dialect, renderContext, this.updateMapper, this.mappingContext);
    }

    @Override
    public List<String> getAllColumns(Class<?> entityType) {
        RelationalPersistentEntity<?> persistentEntity = this.getPersistentEntity(entityType);
        if (persistentEntity == null) {
            return Collections.singletonList("*");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (RelationalPersistentProperty property : persistentEntity) {
            columnNames.add(property.getColumnName());
        }
        return columnNames;
    }

    @Override
    public List<String> getIdentifierColumns(Class<?> entityType) {
        RelationalPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entityType);
        ArrayList<String> columnNames = new ArrayList<String>();
        for (RelationalPersistentProperty property : persistentEntity) {
            if (!property.isIdProperty()) continue;
            columnNames.add(property.getColumnName());
        }
        return columnNames;
    }

    @Override
    public OutboundRow getOutboundRow(Object object) {
        Assert.notNull((Object)object, (String)"Entity object must not be null!");
        OutboundRow row = new OutboundRow();
        this.converter.write(object, row);
        RelationalPersistentEntity<?> entity = this.getRequiredPersistentEntity(ClassUtils.getUserClass((Object)object));
        for (RelationalPersistentProperty property : entity) {
            SettableValue value;
            if (!this.shouldConvertArrayValue(property, value = row.get(property.getColumnName()))) continue;
            SettableValue writeValue = this.getArrayValue(value, property);
            row.put(property.getColumnName(), writeValue);
        }
        return row;
    }

    private boolean shouldConvertArrayValue(RelationalPersistentProperty property, SettableValue value) {
        return value != null && value.hasValue() && property.isCollectionLike();
    }

    private SettableValue getArrayValue(SettableValue value, RelationalPersistentProperty property) {
        ArrayColumns arrayColumns = this.dialect.getArraySupport();
        if (!arrayColumns.isSupported()) {
            throw new InvalidDataAccessResourceUsageException("Dialect " + this.dialect.getClass().getName() + " does not support array columns");
        }
        return SettableValue.fromOrEmpty(this.converter.getArrayValue(arrayColumns, property, value.getValue()), property.getActualType());
    }

    @Override
    public <T> BiFunction<Row, RowMetadata, T> getRowMapper(Class<T> typeToRead) {
        return new EntityRowMapper<T>(typeToRead, this.converter);
    }

    @Override
    public String getTableName(Class<?> type) {
        return this.getRequiredPersistentEntity(type).getTableName();
    }

    @Override
    public StatementMapper getStatementMapper() {
        return this.statementMapper;
    }

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return this.dialect.getBindMarkersFactory();
    }

    @Override
    public R2dbcConverter getConverter() {
        return this.converter;
    }

    public MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private RelationalPersistentEntity<?> getRequiredPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToRead);
    }

    @Nullable
    private RelationalPersistentEntity<?> getPersistentEntity(Class<?> typeToRead) {
        return (RelationalPersistentEntity)this.mappingContext.getPersistentEntity(typeToRead);
    }
}

