/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.r2dbc.core.BindParameterSource;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.util.Assert;

class MapBindParameterSource
implements BindParameterSource {
    private final Map<String, SettableValue> values;

    MapBindParameterSource() {
        this(new LinkedHashMap<String, SettableValue>());
    }

    MapBindParameterSource(Map<String, SettableValue> values) {
        Assert.notNull(values, (String)"Values must not be null");
        this.values = values;
    }

    MapBindParameterSource addValue(String paramName, Object value) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.values.put(paramName, SettableValue.fromOrEmpty(value, value.getClass()));
        return this;
    }

    @Override
    public boolean hasValue(String paramName) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null!");
        return this.values.containsKey(paramName);
    }

    @Override
    public Class<?> getType(String paramName) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null!");
        SettableValue settableValue = this.values.get(paramName);
        if (settableValue != null) {
            return settableValue.getType();
        }
        return Object.class;
    }

    @Override
    public Object getValue(String paramName) throws IllegalArgumentException {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("No value registered for key '" + paramName + "'");
        }
        return this.values.get(paramName).getValue();
    }
}

