/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.r2dbc.core.BindParameterSource;
import org.springframework.data.r2dbc.core.BindableOperation;
import org.springframework.data.r2dbc.core.NamedParameterUtils;
import org.springframework.data.r2dbc.core.ParsedSql;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.BindTarget;

public class NamedParameterExpander {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private volatile int cacheLimit = 256;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, ParsedSql> parsedSqlCache = new LinkedHashMap<String, ParsedSql>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ParsedSql> eldest) {
            return this.size() > NamedParameterExpander.this.getCacheLimit();
        }
    };

    private NamedParameterExpander() {
    }

    public static NamedParameterExpander disabled() {
        return Disabled.INSTANCE;
    }

    public static NamedParameterExpander enabled() {
        return new NamedParameterExpander();
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String sql) {
        if (this.getCacheLimit() <= 0) {
            return NamedParameterUtils.parseSqlStatement(sql);
        }
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(sql);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(sql);
                this.parsedSqlCache.put(sql, parsedSql);
            }
            return parsedSql;
        }
    }

    BindableOperation expand(String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        BindableOperation expanded = NamedParameterUtils.substituteNamedParameters(parsedSql, bindMarkersFactory, paramSource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Expanding SQL statement [%s] to [%s]", sql, expanded.toQuery()));
        }
        return expanded;
    }

    static class Disabled
    extends NamedParameterExpander {
        private static final Disabled INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        BindableOperation expand(final String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
            return new BindableOperation(){

                @Override
                public void bind(BindTarget target, String identifier, Object value) {
                    target.bind(identifier, value);
                }

                @Override
                public void bindNull(BindTarget target, String identifier, Class<?> valueType) {
                    target.bindNull(identifier, valueType);
                }

                @Override
                public String toQuery() {
                    return sql;
                }
            };
        }
    }
}

