/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.r2dbc.core.BindParameterSource;
import org.springframework.data.r2dbc.core.BindableOperation;
import org.springframework.data.r2dbc.core.ParsedSql;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindMarkers;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.BindTarget;
import org.springframework.util.Assert;

abstract class NamedParameterUtils {
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};
    private static final String PARAMETER_SEPARATORS = "\"':&,;()|=+-*%/\\<>^";
    private static final boolean[] separatorIndex = new boolean[128];

    NamedParameterUtils() {
    }

    public static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        HashSet<String> namedParameters = new HashSet<String>();
        String sqlToUse = sql;
        ArrayList<ParameterHolder> parameterList = new ArrayList<ParameterHolder>();
        char[] statement = sql.toCharArray();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        int escapes = 0;
        int i = 0;
        while (i < statement.length) {
            int j;
            int skipToPosition = i;
            while (i < statement.length && i != (skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i))) {
                i = skipToPosition;
            }
            if (i >= statement.length) break;
            char c = statement[i];
            if (c == ':' || c == '&') {
                if (c == ':' && j < statement.length && statement[j] == ':') {
                    i += 2;
                    continue;
                }
                String parameter = null;
                if (c == ':' && j < statement.length && statement[j] == '{') {
                    while (statement[j] != '}') {
                        if (++j >= statement.length) {
                            throw new InvalidDataAccessApiUsageException("Non-terminated named parameter declaration at position " + i + " in statement: " + sql);
                        }
                        if (statement[j] != ':' && statement[j] != '{') continue;
                        throw new InvalidDataAccessApiUsageException("Parameter name contains invalid character '" + statement[j] + "' at position " + i + " in statement: " + sql);
                    }
                    if (j - i > 2) {
                        parameter = sql.substring(i + 2, j);
                        namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                        totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j + 1, parameter);
                    }
                    ++j;
                } else {
                    for (j = i + 1; j < statement.length && !NamedParameterUtils.isParameterSeparator(statement[j]); ++j) {
                    }
                    if (j - i > 1) {
                        parameter = sql.substring(i + 1, j);
                        namedParameterCount = NamedParameterUtils.addNewNamedParameter(namedParameters, namedParameterCount, parameter);
                        totalParameterCount = NamedParameterUtils.addNamedParameter(parameterList, totalParameterCount, escapes, i, j, parameter);
                    }
                }
                i = j - 1;
            } else if (c == '\\' && (j = i + 1) < statement.length && statement[j] == ':') {
                sqlToUse = sqlToUse.substring(0, i - escapes) + sqlToUse.substring(i - escapes + 1);
                ++escapes;
                i += 2;
                continue;
            }
            ++i;
        }
        ParsedSql parsedSql = new ParsedSql(sqlToUse);
        for (ParameterHolder ph : parameterList) {
            parsedSql.addNamedParameter(ph.getParameterName(), ph.getStartIndex(), ph.getEndIndex());
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int addNamedParameter(List<ParameterHolder> parameterList, int totalParameterCount, int escapes, int i, int j, String parameter) {
        parameterList.add(new ParameterHolder(parameter, i - escapes, j - escapes));
        return ++totalParameterCount;
    }

    private static int addNewNamedParameter(Set<String> namedParameters, int namedParameterCount, String parameter) {
        if (!namedParameters.contains(parameter)) {
            namedParameters.add(parameter);
            ++namedParameterCount;
        }
        return namedParameterCount;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    public static BindableOperation substituteNamedParameters(ParsedSql parsedSql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        BindMarkerHolder markerHolder = new BindMarkerHolder(bindMarkersFactory.create());
        String originalSql = parsedSql.getOriginalSql();
        List<String> paramNames = parsedSql.getParameterNames();
        if (paramNames.isEmpty()) {
            return new ExpandedQuery(originalSql, markerHolder);
        }
        StringBuilder actualSql = new StringBuilder(originalSql.length());
        int lastIndex = 0;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql, lastIndex, startIndex);
            if (paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append('(');
                            for (int m = 0; m < expressionList.length; ++m) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append(markerHolder.addMarker(paramName));
                            }
                            actualSql.append(')');
                            continue;
                        }
                        actualSql.append(markerHolder.addMarker(paramName));
                    }
                } else {
                    actualSql.append(markerHolder.addMarker(paramName));
                }
            } else {
                actualSql.append(markerHolder.addMarker(paramName));
            }
            lastIndex = endIndex;
        }
        actualSql.append(originalSql, lastIndex, originalSql.length());
        return new ExpandedQuery(actualSql.toString(), markerHolder);
    }

    private static boolean isParameterSeparator(char c) {
        return c < '\u0080' && separatorIndex[c] || Character.isWhitespace(c);
    }

    public static BindableOperation substituteNamedParameters(String sql, BindMarkersFactory bindMarkersFactory, BindParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, bindMarkersFactory, paramSource);
    }

    static {
        for (char c : PARAMETER_SEPARATORS.toCharArray()) {
            NamedParameterUtils.separatorIndex[c] = true;
        }
    }

    private static class ExpandedQuery
    implements BindableOperation {
        private final String expandedSql;
        private final Map<String, List<BindMarker>> markers;

        ExpandedQuery(String expandedSql, BindMarkerHolder bindMarkerHolder) {
            this.expandedSql = expandedSql;
            this.markers = bindMarkerHolder.markers;
        }

        @Override
        public void bind(BindTarget target, String identifier, Object value) {
            List<BindMarker> bindMarkers = this.getBindMarkers(identifier);
            if (bindMarkers == null) {
                target.bind(identifier, value);
                return;
            }
            if (bindMarkers.size() == 1) {
                bindMarkers.get(0).bind(target, value);
            } else {
                Assert.isInstanceOf(Collection.class, (Object)value, () -> String.format("Value [%s] must be an Collection with a size of [%d]", value, bindMarkers.size()));
                Collection collection = (Collection)value;
                Iterator iterator = collection.iterator();
                Iterator<BindMarker> markers = bindMarkers.iterator();
                while (iterator.hasNext()) {
                    Object valueToBind = iterator.next();
                    if (valueToBind instanceof Object[]) {
                        Object[] objects;
                        for (Object object : objects = (Object[])valueToBind) {
                            this.bind(target, markers, object);
                        }
                        continue;
                    }
                    this.bind(target, markers, valueToBind);
                }
            }
        }

        private void bind(BindTarget target, Iterator<BindMarker> markers, Object valueToBind) {
            Assert.isTrue((boolean)markers.hasNext(), () -> String.format("No bind marker for value [%s] in SQL [%s]. Check that the query was expanded using the same arguments.", valueToBind, this.toQuery()));
            markers.next().bind(target, valueToBind);
        }

        @Override
        public void bindNull(BindTarget target, String identifier, Class<?> valueType) {
            List<BindMarker> bindMarkers = this.getBindMarkers(identifier);
            if (bindMarkers.size() == 1) {
                bindMarkers.get(0).bindNull(target, valueType);
                return;
            }
            throw new UnsupportedOperationException("bindNull(\u2026) can bind only singular values");
        }

        private List<BindMarker> getBindMarkers(String identifier) {
            return this.markers.get(identifier);
        }

        @Override
        public String toQuery() {
            return this.expandedSql;
        }
    }

    private static class BindMarkerHolder {
        private final BindMarkers bindMarkers;
        private final Map<String, List<BindMarker>> markers = new TreeMap<String, List<BindMarker>>();

        BindMarkerHolder(BindMarkers bindMarkers) {
            this.bindMarkers = bindMarkers;
        }

        String addMarker(String name) {
            BindMarker bindMarker = this.bindMarkers.next(name);
            this.markers.computeIfAbsent(name, ignore -> new ArrayList()).add(bindMarker);
            return bindMarker.getPlaceholder();
        }
    }

    private static final class ParameterHolder {
        private final String parameterName;
        private final int startIndex;
        private final int endIndex;

        public ParameterHolder(String parameterName, int startIndex, int endIndex) {
            this.parameterName = parameterName;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterHolder)) {
                return false;
            }
            ParameterHolder other = (ParameterHolder)o;
            String this$parameterName = this.getParameterName();
            String other$parameterName = other.getParameterName();
            if (this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName)) {
                return false;
            }
            if (this.getStartIndex() != other.getStartIndex()) {
                return false;
            }
            return this.getEndIndex() == other.getEndIndex();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $parameterName = this.getParameterName();
            result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
            result = result * 59 + this.getStartIndex();
            result = result * 59 + this.getEndIndex();
            return result;
        }

        public String toString() {
            return "NamedParameterUtils.ParameterHolder(parameterName=" + this.getParameterName() + ", startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ")";
        }
    }
}

