/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.lang.Nullable;

public interface StatementMapper {
    public <T> TypedStatementMapper<T> forType(Class<T> var1);

    public PreparedOperation<?> getMappedObject(SelectSpec var1);

    public PreparedOperation<?> getMappedObject(InsertSpec var1);

    public PreparedOperation<?> getMappedObject(UpdateSpec var1);

    public PreparedOperation<?> getMappedObject(DeleteSpec var1);

    default public SelectSpec createSelect(String table) {
        return SelectSpec.create(table);
    }

    default public InsertSpec createInsert(String table) {
        return InsertSpec.create(table);
    }

    default public UpdateSpec createUpdate(String table, Update update) {
        return UpdateSpec.create(table, update);
    }

    default public DeleteSpec createDelete(String table) {
        return DeleteSpec.create(table);
    }

    public static class DeleteSpec {
        private final String table;
        @Nullable
        private final Criteria criteria;

        protected DeleteSpec(String table, @Nullable Criteria criteria) {
            this.table = table;
            this.criteria = criteria;
        }

        public static DeleteSpec create(String table) {
            return new DeleteSpec(table, null);
        }

        public DeleteSpec withCriteria(Criteria criteria) {
            return new DeleteSpec(this.table, criteria);
        }

        public String getTable() {
            return this.table;
        }

        @Nullable
        public Criteria getCriteria() {
            return this.criteria;
        }
    }

    public static class UpdateSpec {
        private final String table;
        private final Update update;
        @Nullable
        private final Criteria criteria;

        protected UpdateSpec(String table, Update update, @Nullable Criteria criteria) {
            this.table = table;
            this.update = update;
            this.criteria = criteria;
        }

        public static UpdateSpec create(String table, Update update) {
            return new UpdateSpec(table, update, null);
        }

        public UpdateSpec withCriteria(Criteria criteria) {
            return new UpdateSpec(this.table, this.update, criteria);
        }

        public String getTable() {
            return this.table;
        }

        public Update getUpdate() {
            return this.update;
        }

        @Nullable
        public Criteria getCriteria() {
            return this.criteria;
        }
    }

    public static class InsertSpec {
        private final String table;
        private final Map<String, SettableValue> assignments;

        protected InsertSpec(String table, Map<String, SettableValue> assignments) {
            this.table = table;
            this.assignments = assignments;
        }

        public static InsertSpec create(String table) {
            return new InsertSpec(table, Collections.emptyMap());
        }

        public InsertSpec withColumn(String column, SettableValue value) {
            LinkedHashMap<String, SettableValue> values = new LinkedHashMap<String, SettableValue>(this.assignments);
            values.put(column, value);
            return new InsertSpec(this.table, values);
        }

        public String getTable() {
            return this.table;
        }

        public Map<String, SettableValue> getAssignments() {
            return Collections.unmodifiableMap(this.assignments);
        }
    }

    public static class SelectSpec {
        private final String table;
        private final List<String> projectedFields;
        @Nullable
        private final Criteria criteria;
        private final Sort sort;
        private final Pageable page;

        protected SelectSpec(String table, List<String> projectedFields, @Nullable Criteria criteria, Sort sort, Pageable page) {
            this.table = table;
            this.projectedFields = projectedFields;
            this.criteria = criteria;
            this.sort = sort;
            this.page = page;
        }

        public static SelectSpec create(String table) {
            return new SelectSpec(table, Collections.emptyList(), null, Sort.unsorted(), Pageable.unpaged());
        }

        public SelectSpec withProjection(Collection<String> projectedFields) {
            ArrayList<String> fields = new ArrayList<String>(this.projectedFields);
            fields.addAll(projectedFields);
            return new SelectSpec(this.table, fields, this.criteria, this.sort, this.page);
        }

        public SelectSpec withCriteria(Criteria criteria) {
            return new SelectSpec(this.table, this.projectedFields, criteria, this.sort, this.page);
        }

        public SelectSpec withSort(Sort sort) {
            return new SelectSpec(this.table, this.projectedFields, this.criteria, sort, this.page);
        }

        public SelectSpec withPage(Pageable page) {
            if (page.isPaged()) {
                Sort sort = page.getSort();
                return new SelectSpec(this.table, this.projectedFields, this.criteria, sort.isSorted() ? sort : this.sort, page);
            }
            return new SelectSpec(this.table, this.projectedFields, this.criteria, this.sort, page);
        }

        public String getTable() {
            return this.table;
        }

        public List<String> getProjectedFields() {
            return Collections.unmodifiableList(this.projectedFields);
        }

        @Nullable
        public Criteria getCriteria() {
            return this.criteria;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Pageable getPage() {
            return this.page;
        }
    }

    public static interface TypedStatementMapper<T>
    extends StatementMapper {
    }
}

