/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.dialect.H2Dialect;
import org.springframework.data.r2dbc.dialect.MySqlDialect;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.dialect.SqlServerDialect;
import org.springframework.util.Assert;

public enum Database {
    POSTGRES{

        @Override
        public String driverName() {
            return "PostgreSQL";
        }

        @Override
        public Dialect defaultDialect() {
            return PostgresDialect.INSTANCE;
        }
    }
    ,
    SQL_SERVER{

        @Override
        public String driverName() {
            return "Microsoft SQL Server";
        }

        @Override
        public Dialect defaultDialect() {
            return SqlServerDialect.INSTANCE;
        }
    }
    ,
    H2{

        @Override
        public String driverName() {
            return "H2";
        }

        @Override
        public Dialect defaultDialect() {
            return H2Dialect.INSTANCE;
        }
    }
    ,
    MYSQL{

        @Override
        public String driverName() {
            return "MySQL";
        }

        @Override
        public Dialect defaultDialect() {
            return MySqlDialect.INSTANCE;
        }
    };


    public static Optional<Database> findDatabase(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        ConnectionFactoryMetadata metadata = connectionFactory.getMetadata();
        return Arrays.stream(Database.values()).filter(it -> Database.matches(metadata, it.driverName())).findFirst();
    }

    private static boolean matches(ConnectionFactoryMetadata metadata, String databaseType) {
        return metadata.getName().toLowerCase(Locale.ENGLISH).contains(databaseType.toLowerCase(Locale.ENGLISH));
    }

    public abstract String driverName();

    public abstract Dialect defaultDialect();
}

